/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.annotation.NoAspect;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.util.L10N;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

@NoAspect
public class BootServerMultiConfig {
    private static final L10N L = new L10N(BootServerMultiConfig.class);
    private String _idPrefix = null;
    private String _addresses;
    private int _port = -1;
    private ArrayList<String> _addressList = new ArrayList();
    private boolean _isSecure;
    private boolean _isAllowNonReservedIp;
    private ContainerProgram _serverProgram = new ContainerProgram();

    public String getIdPrefix() {
        return this._idPrefix;
    }

    @Configurable
    public void setIdPrefix(String id) {
        this._idPrefix = id;
    }

    @Configurable
    public void setAddressList(String addresses) {
        this._addresses = addresses;
    }

    public ArrayList<String> getAddressList() {
        return this._addressList;
    }

    public int getPort() {
        return this._port;
    }

    @Configurable
    public void setPort(int port) {
        this._port = port;
    }

    @Configurable
    public void setClusterPort(ConfigProgram program) {
        this._serverProgram.addProgram(program);
        ClusterPortConfig cfg = new ClusterPortConfig();
        program.configure(cfg);
        if (cfg.getPort() >= 0) {
            this.setPort(cfg.getPort());
        }
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    public void setAllowNonReservedIp(boolean isAllow) {
        this._isAllowNonReservedIp = isAllow;
    }

    public boolean isAllowNonReservedIp() {
        return this._isAllowNonReservedIp;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._serverProgram.addProgram(program);
    }

    public ConfigProgram getServerProgram() {
        return this._serverProgram;
    }

    @PostConstruct
    public void init() {
        if (this._idPrefix == null) {
            throw new ConfigException(L.l("server-multi requires an id-prefix"));
        }
        this.fillAddresses();
    }

    private void fillAddresses() {
        if (this._addresses == null) {
            return;
        }
        ArrayList<String> addressList = new ArrayList<String>();
        for (String item : this._addresses.split("[\\s;]+")) {
            if ("".equals(item)) continue;
            int p = item.lastIndexOf(58);
            if (p > 0) {
                addressList.add(item);
                continue;
            }
            if (this._port <= 0) {
                throw new ConfigException(L.l("port is required in server-multi when address-list {0} does not define the port.", (Object)this._addresses));
            }
            addressList.add(item + ":" + this._port);
        }
        this._addressList = addressList;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._idPrefix + "]";
    }

    static class ClusterPortConfig {
        private int _port = -1;

        ClusterPortConfig() {
        }

        public int getPort() {
            return this._port;
        }

        public void setPort(int port) {
            this._port = port;
        }

        public ClusterPortConfig createClusterPort() {
            return this;
        }

        public void addBuilderProgram(ConfigProgram program) {
        }
    }
}

