/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.cloud.license.LicenseClient;
import com.caucho.cloud.loadbalance.LoadBalanceFactory;
import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.network.NetworkClusterSystem;
import com.caucho.cloud.security.SecurityService;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.cloud.topology.TopologyService;
import com.caucho.config.ConfigException;
import com.caucho.db.block.BlockManager;
import com.caucho.db.block.BlockManagerSubSystem;
import com.caucho.env.health.HealthStatusService;
import com.caucho.env.log.LogSystem;
import com.caucho.env.repository.AbstractRepository;
import com.caucho.env.repository.RepositorySpi;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.env.warning.WarningService;
import com.caucho.license.LicenseCheck;
import com.caucho.license.LicenseStore;
import com.caucho.server.admin.Management;
import com.caucho.server.admin.StatSystem;
import com.caucho.server.cluster.ClusterPod;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.distcache.CacheStoreManager;
import com.caucho.server.distcache.DistCacheSystem;
import com.caucho.server.httpcache.TempFileService;
import com.caucho.server.resin.BootClusterConfig;
import com.caucho.server.resin.ManagementAdmin;
import com.caucho.server.resin.Resin;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResinDelegate {
    private static Logger log = Logger.getLogger(ResinDelegate.class.getName());
    private static L10N L = new L10N(ResinDelegate.class);
    private final Resin _resin;
    private String _licenseErrorMessage;
    protected LicenseStore _licenseStore;

    public ResinDelegate(Resin resin) {
        this._resin = resin;
    }

    public void init() {
        this._licenseStore = new LicenseStore();
        try {
            this._licenseStore.init(null);
        }
        catch (IOException e) {
            log.log(Level.FINER, e.getMessage(), e);
        }
        catch (ConfigException e) {
            log.log(Level.FINER, e.getMessage(), e);
        }
    }

    public LicenseStore getLicenseStore() {
        return this._licenseStore;
    }

    public static ResinDelegate create(Resin resin) {
        Class<?> cl;
        if (resin.getArgs().isOpenSource()) {
            return new ResinDelegate(resin);
        }
        String licenseErrorMessage = null;
        ResinDelegate delegate = null;
        try {
            cl = Class.forName("com.caucho.server.resin.ProResinDelegate");
            Constructor<?> ctor = cl.getConstructor(Resin.class);
            delegate = (ResinDelegate)ctor.newInstance(resin);
        }
        catch (ConfigException e) {
            log.log(Level.FINER, e.toString(), e);
            licenseErrorMessage = e.getMessage();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            log.log(Level.FINER, cause.toString(), cause);
            licenseErrorMessage = cause instanceof ConfigException ? cause.getMessage() : L.l("  Using Resin(R) Open Source under the GNU Public License (GPL).\n\n  See http://www.caucho.com for information on Resin Professional,\n  including caching, clustering, JNI acceleration, and OpenSSL integration.\n\n  Exception=" + cause + "\n");
        }
        catch (Throwable e) {
            String msg;
            log.log(Level.FINER, e.toString(), e);
            String causeMsg = "";
            if (!(e instanceof ClassNotFoundException)) {
                causeMsg = "\n  Exception=" + e + "\n";
            }
            licenseErrorMessage = msg = L.l("  Using Resin(R) Open Source under the GNU Public License (GPL).\n\n  See http://www.caucho.com for information on Resin Professional,\n  including caching, clustering, JNI acceleration, and OpenSSL integration.\n" + causeMsg);
        }
        if (delegate == null) {
            try {
                cl = Class.forName("com.caucho.license.LicenseCheckImpl");
                LicenseCheck license = (LicenseCheck)cl.newInstance();
                license.requirePersonal(1);
                licenseErrorMessage = license.doLogging();
            }
            catch (ConfigException e) {
                licenseErrorMessage = e.getMessage();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            delegate = new ResinDelegate(resin);
            delegate.setLicenseErrorMessage(licenseErrorMessage);
            delegate.init();
        }
        return delegate;
    }

    public static ResinDelegate createOpenSource(Resin resin) {
        return new ResinDelegate(resin);
    }

    protected Resin getResin() {
        return this._resin;
    }

    protected String getLicenseMessage() {
        return null;
    }

    protected void setLicenseErrorMessage(String msg) {
        this._licenseErrorMessage = msg;
    }

    protected String getLicenseErrorMessage() {
        return this._licenseErrorMessage;
    }

    protected DistCacheSystem createDistCacheService() {
        return DistCacheSystem.createAndAddService(new CacheStoreManager(this._resin.getResinSystem()));
    }

    protected void addServices() {
        TempFileService.createAndAddService();
        this.createManagementMBean();
    }

    protected ManagementAdmin createManagementMBean() {
        return new ManagementAdmin(this._resin);
    }

    protected ServletService createServer() {
        return new ServletService(this.getResin());
    }

    protected Management createResinManagement() {
        return new ManagementDummyConfig();
    }

    public StatSystem createStatSystem() {
        throw new ConfigException("StatSystem is available with Resin Professional");
    }

    protected String getResinName() {
        return "Resin";
    }

    public boolean isProfessional() {
        return false;
    }

    public LogSystem createLogSystem() {
        throw new ConfigException("LogSystem is available with Resin Professional");
    }

    public AbstractRepository createRepository(RepositorySpi localRepository) {
        return (AbstractRepository)localRepository;
    }

    protected CloudServer joinCluster(CloudSystem system, BootClusterConfig cluster) {
        throw new ConfigException(L.l("--elastic-server requires Resin Professional"));
    }

    protected ClusterServer loadDynamicServer(ClusterPod pod, String dynId, String dynAddress, int dynPort) {
        throw new ConfigException(L.l("dynamic-server requires Resin Professional"));
    }

    protected void validateServerCluster() {
        if (this.getResin().getSelfServer().getPod().getServerLength() <= 1) {
            return;
        }
        if (this.loadCloudLicenses()) {
            ShutdownSystem.shutdownActive(ExitCode.MODIFIED, L.l("{0} has loaded new licenses, and requires a restart.", (Object)this.getResin()));
        }
        throw new ConfigException(L.l("{0} does not support multiple <server> instances in a cluster.\nFor clustered servers, please use Resin Professional with a valid license.", (Object)this.getResin()));
    }

    protected boolean loadCloudLicenses() {
        try {
            Class<?> cl = Class.forName("com.caucho.cloud.license.LicenseClientImpl");
            LicenseClient client = (LicenseClient)cl.newInstance();
            Path licenses = this.getResin().getServerDataDirectory().lookup("licenses");
            return client.loadLicenses(licenses, this.getResin().getSelfServer().getPod());
        }
        catch (ClassNotFoundException e) {
            log.log(Level.ALL, e.toString(), e);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return false;
    }

    public void dumpThreads() {
    }

    public void dumpHeapOnExit() {
    }

    protected NetworkClusterSystem createNetworkSystem(CloudServer server) {
        return new NetworkClusterSystem(server);
    }

    protected LoadBalanceFactory createLoadBalanceFactory() {
        return new LoadBalanceFactory();
    }

    protected void addPreTopologyServices() {
        WarningService.createAndAddService();
        ShutdownSystem.createAndAddService(this.getResin().isEmbedded());
        HealthStatusService.createAndAddService();
        TopologyService.createAndAddService(this.getResin().getServerId());
        SecurityService.createAndAddService();
        BlockManagerSubSystem.createAndAddService();
        if (!this.getResin().isWatchdog()) {
            this.createDistCacheService();
            ShutdownSystem.getCurrent().addMemoryFreeTask(new BlockManagerMemoryFreeTask());
        }
    }

    public LicenseCheck getLicenseCheck() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static class ManagementDummyConfig
    extends Management {
        ManagementDummyConfig() {
        }
    }

    static class BlockManagerMemoryFreeTask
    implements Runnable {
        private BlockManager _blockManager = BlockManager.create();

        BlockManagerMemoryFreeTask() {
        }

        @Override
        public void run() {
            BlockManager blockManager = this._blockManager;
            if (blockManager != null) {
                blockManager.clear();
            }
        }
    }
}

