/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.server.rewrite.AbstractCondition;
import com.caucho.util.L10N;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerNameCondition
extends AbstractCondition {
    private static final L10N L = new L10N(ServerNameCondition.class);
    private final Pattern _regexp;

    ServerNameCondition(String regexp) {
        this._regexp = Pattern.compile(regexp, 2);
    }

    @Override
    public String getTagName() {
        return "server-name";
    }

    @Override
    public boolean isMatch(HttpServletRequest request, HttpServletResponse response) {
        String serverName = request.getServerName();
        return serverName != null && this._regexp.matcher(serverName).find();
    }
}

