/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.server.session.HessianSessionSerializer;
import com.caucho.server.session.SessionDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HessianSessionDeserializer
extends SessionDeserializer {
    private static final Logger log = Logger.getLogger(HessianSessionSerializer.class.getName());
    private Hessian2Input _in;

    public HessianSessionDeserializer(InputStream is) {
        this(is, Thread.currentThread().getContextClassLoader());
    }

    public HessianSessionDeserializer(InputStream is, ClassLoader loader) {
        if (log.isLoggable(Level.FINEST)) {
            HessianDebugInputStream dis = new HessianDebugInputStream(is, log, Level.FINEST);
            log.finest("session serialized load data:");
            dis.setDepth(2);
            is = dis;
        }
        this._in = new Hessian2Input(is);
        this._in.setSerializerFactory(new SerializerFactory(loader));
    }

    @Override
    public int readInt() throws IOException {
        return this._in.readInt();
    }

    @Override
    public Object readObject() throws IOException {
        return this._in.readObject();
    }

    @Override
    public void close() {
        Hessian2Input in = this._in;
        this._in = null;
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
    }
}

