/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.PersistentStoreMXBean;
import com.caucho.management.server.SessionManagerMXBean;
import com.caucho.management.server.WebAppMXBean;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;

public class SessionManagerAdmin
extends AbstractManagedObject
implements SessionManagerMXBean {
    private final SessionManager _manager;

    public SessionManagerAdmin(SessionManager manager) {
        this._manager = manager;
        this.registerSelf();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public WebAppMXBean getWebApp() {
        return this._manager.getWebApp().getAdmin();
    }

    @Override
    public boolean isAlwaysSaveSession() {
        return this._manager.getAlwaysSaveSession();
    }

    @Override
    public boolean isCookieAppendServerIndex() {
        return this._manager.isCookieAppendServerIndex();
    }

    @Override
    public String getCookieDomain() {
        return this._manager.getCookieDomain();
    }

    @Override
    public boolean isCookieHttpOnly() {
        return this._manager.isCookieHttpOnly();
    }

    @Override
    public long getCookieLength() {
        return this._manager.getCookieLength();
    }

    @Override
    public long getCookieMaxAge() {
        return this._manager.getCookieMaxAge();
    }

    @Override
    public String getCookieName() {
        return this._manager.getCookieName();
    }

    @Override
    public String getCookiePort() {
        return this._manager.getCookiePort();
    }

    @Override
    public boolean isCookieSecure() {
        return this._manager.isCookieSecure();
    }

    @Override
    public int getCookieVersion() {
        return this._manager.getCookieVersion();
    }

    @Override
    public boolean isEnableCookies() {
        return this._manager.enableSessionCookies();
    }

    @Override
    public boolean isEnableURLRewriting() {
        return this._manager.enableSessionUrls();
    }

    @Override
    public boolean isIgnoreSerializationErrors() {
        return this._manager.getIgnoreSerializationErrors();
    }

    @Override
    public boolean isInvalidateAfterListener() {
        return this._manager.isInvalidateAfterListener();
    }

    @Override
    public boolean isReuseSessionId() {
        return this._manager.getReuseSessionId() != 0;
    }

    @Override
    public String getSaveMode() {
        return this._manager.getSaveMode();
    }

    @Override
    public int getSessionMax() {
        return this._manager.getSessionMax();
    }

    @Override
    public long getSessionTimeout() {
        return this._manager.getSessionTimeout();
    }

    @Override
    public PersistentStoreMXBean getPersistentStore() {
        return null;
    }

    public int getActiveSessionCount() {
        return this._manager.getActiveSessionCount();
    }

    @Override
    public long getSessionActiveCount() {
        return this._manager.getSessionActiveCount();
    }

    @Override
    public long getSessionCreateCountTotal() {
        return this._manager.getSessionCreateCount();
    }

    @Override
    public long getSessionInvalidateCountTotal() {
        return this._manager.getSessionInvalidateCount();
    }

    @Override
    public long getSessionTimeoutCountTotal() {
        return this._manager.getSessionTimeoutCount();
    }

    public String getSessionStoreType() {
        return "unknown";
    }

    @Override
    public String sessionSerializationDebug(String id) {
        return this._manager.getSessionSerializationDebug(id);
    }

    @Override
    public String sessionAsJsonString(String id) {
        return this._manager.getSessionAsJsonString(id);
    }

    @Override
    public String[] sessionIdList() {
        return this._manager.sessionIdList();
    }

    @Override
    public String sessionsAsJsonString() {
        return this._manager.getSessionsAsJsonString();
    }

    @Override
    public long getEstimatedMemorySize() {
        return this._manager.getEstimatedMemorySize();
    }

    @Override
    public int stickySessionServer(String sessionId, int count) {
        int hash = SessionManager.getServerCode(sessionId, count);
        WebApp webApp = this._manager.getWebApp();
        ServletService servlet = webApp.getServer();
        ClusterServer server = servlet.getSelfServer();
        return hash % server.getCloudPod().getServerLength();
    }

    public void unregister() {
        this.unregisterSelf();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getObjectName() + "]";
    }
}

