/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.snmp.types;

import com.caucho.server.snmp.types.IntegerValue;
import com.caucho.server.snmp.types.OctetStringValue;
import com.caucho.server.snmp.types.PduValue;
import com.caucho.server.snmp.types.SnmpValue;
import com.caucho.server.snmp.types.VarBindListValue;
import com.caucho.server.snmp.types.VarBindValue;

public class SnmpMessageValue
extends SnmpValue {
    IntegerValue _version = IntegerValue.ZERO;
    OctetStringValue _communityString = OctetStringValue.PUBLIC;
    PduValue _pdu;

    public SnmpMessageValue(int version, String community, PduValue pdu) {
        this(new IntegerValue(version), new OctetStringValue(community), pdu);
    }

    public SnmpMessageValue(IntegerValue version, OctetStringValue community, PduValue pdu) {
        this._version = version;
        this._communityString = community;
        this._pdu = pdu;
    }

    @Override
    public int getType() {
        return 48;
    }

    @Override
    public void toAsn1(StringBuilder sb) {
        StringBuilder innerSb = new StringBuilder();
        this._version.toAsn1(innerSb);
        this._communityString.toAsn1(innerSb);
        this._pdu.toAsn1(innerSb);
        this.header(sb, innerSb.length());
        sb.append(innerSb.toString());
    }

    public IntegerValue getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = new IntegerValue(version);
    }

    public void setVersion(IntegerValue version) {
        this._version = version;
    }

    public OctetStringValue getCommunityString() {
        return this._communityString;
    }

    public void setCommunityString(String communityString) {
        this._communityString = new OctetStringValue(communityString);
    }

    public void setCommunityString(OctetStringValue communityString) {
        this._communityString = communityString;
    }

    public PduValue getPdu() {
        return this._pdu;
    }

    public void setPdu(PduValue pdu) {
        this._pdu = pdu;
    }

    public void setError(int error) {
        this._pdu.setError(error);
    }

    public void setError(IntegerValue error) {
        this._pdu.setError(error);
    }

    public IntegerValue getError() {
        return this._pdu.getError();
    }

    public void setErrorIndex(int errorIndex) {
        this._pdu.setErrorIndex(errorIndex);
    }

    public void setErrorIndex(IntegerValue errorIndex) {
        this._pdu.setErrorIndex(errorIndex);
    }

    public IntegerValue getErrorIndex() {
        return this._pdu.getErrorIndex();
    }

    public void setRequestId(int id) {
        this._pdu.setRequestId(id);
    }

    public void setRequestId(IntegerValue id) {
        this._pdu.setRequestId(id);
    }

    public IntegerValue getRequestId() {
        return this._pdu.getRequestId();
    }

    public void addVarBind(VarBindValue obj) {
        this._pdu.addVarBind(obj);
    }

    public void addVarBindList(VarBindListValue list) {
        this._pdu.addVarBindList(list);
    }

    public VarBindListValue getVarBindList() {
        return this._pdu.getVarBindList();
    }

    public String toString() {
        return "SnmpMessage[" + this._version + "," + this._communityString + "," + this._pdu + "]";
    }
}

