/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.snmp.types;

import com.caucho.server.snmp.types.CounterValue;
import com.caucho.server.snmp.types.GaugeValue;
import com.caucho.server.snmp.types.IntegerValue;
import com.caucho.server.snmp.types.IpAddressValue;
import com.caucho.server.snmp.types.NullValue;
import com.caucho.server.snmp.types.ObjectIdentifierValue;
import com.caucho.server.snmp.types.OctetStringValue;
import com.caucho.server.snmp.types.TimeTicksValue;

public abstract class SnmpValue {
    public static final int EOC = 0;
    public static final int INTEGER = 2;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int SEQUENCE = 48;
    public static final int IP_ADDRESS = 64;
    public static final int COUNTER = 65;
    public static final int GAUGE = 66;
    public static final int TIME_TICKS = 67;
    public static final int OPAQUE = 68;
    public static final int GET_REQUEST_PDU = 160;
    public static final int GET_NEXT_REQUEST_PDU = 161;
    public static final int GET_RESPONSE_PDU = 162;
    public static final int SET_REQUEST_PDU = 163;
    public static final int TRAP_PDU = 164;

    public abstract void toAsn1(StringBuilder var1);

    public abstract int getType();

    public static SnmpValue create(Object obj) {
        if (obj instanceof Number) {
            return new IntegerValue(((Number)obj).intValue());
        }
        if (obj instanceof Boolean) {
            return new IntegerValue((Boolean)obj != false ? 1 : 0);
        }
        return new OctetStringValue(obj.toString());
    }

    public static SnmpValue create(Object obj, String typeStr) {
        if (typeStr == null) {
            return SnmpValue.create(obj);
        }
        int type = 4;
        if (typeStr.equalsIgnoreCase("INTEGER")) {
            type = 2;
        } else if (typeStr.equalsIgnoreCase("TIME_TICKS")) {
            type = 67;
        } else if (typeStr.equalsIgnoreCase("GAUGE")) {
            type = 66;
        } else if (typeStr.equalsIgnoreCase("COUNTER")) {
            type = 65;
        } else if (typeStr.equalsIgnoreCase("OBJECT_IDENTIFIER")) {
            type = 6;
        }
        return SnmpValue.create(obj, type);
    }

    public static SnmpValue create(Object obj, int type) {
        if (obj == null) {
            return new NullValue();
        }
        if (obj instanceof Number) {
            switch (type) {
                case 2: {
                    return new IntegerValue(((Number)obj).intValue());
                }
                case 65: {
                    return new CounterValue(((Number)obj).longValue());
                }
                case 66: {
                    return new GaugeValue(((Number)obj).longValue());
                }
                case 67: {
                    return new TimeTicksValue(((Number)obj).longValue() / 10L);
                }
            }
        }
        switch (type) {
            case 6: {
                return new ObjectIdentifierValue(obj.toString());
            }
            case 64: {
                return new IpAddressValue(obj.toString());
            }
        }
        return new OctetStringValue(obj.toString());
    }

    public final String toAsn1() {
        StringBuilder sb = new StringBuilder();
        this.toAsn1(sb);
        return sb.toString();
    }

    protected final void header(StringBuilder sb, int len) {
        sb.append((char)this.getType());
        if (len < 127) {
            sb.append((char)len);
            return;
        }
        int bytes = 1;
        if (len >> 24 > 0) {
            bytes = 4;
        } else if (len >> 16 > 0) {
            bytes = 3;
        } else if (len >> 8 > 0) {
            bytes = 2;
        }
        sb.append((char)(0x80 | bytes));
        while (bytes > 0) {
            switch (bytes) {
                case 1: {
                    sb.append((char)(len & 0xFF));
                    break;
                }
                case 2: {
                    sb.append((char)(len >> 8 & 0xFF));
                    break;
                }
                case 3: {
                    sb.append((char)(len >> 16 & 0xFF));
                    break;
                }
                case 4: {
                    sb.append((char)(len >> 24 & 0xFF));
                }
            }
            --bytes;
        }
    }

    public long getLong() {
        throw new UnsupportedOperationException();
    }

    public String getString() {
        throw new UnsupportedOperationException();
    }

    public static String typeName(int identifier) {
        switch (identifier) {
            case 0: {
                return "EOC";
            }
            case 2: {
                return "INTEGER";
            }
            case 4: {
                return "OCTET_STRING";
            }
            case 5: {
                return "NULL";
            }
            case 6: {
                return "OBJECT_IDENTIFIER";
            }
            case 48: {
                return "SEQUENCE";
            }
            case 64: {
                return "IP_ADDRESS";
            }
            case 65: {
                return "COUNTER";
            }
            case 66: {
                return "GAUGE";
            }
            case 67: {
                return "TIME_TICKS";
            }
            case 68: {
                return "OPAQUE";
            }
            case 160: {
                return "GET_REQUEST_PDU";
            }
            case 161: {
                return "GET_NEXT_REQUEST_PDU";
            }
            case 162: {
                return "GET_RESPONSE_PDU";
            }
            case 163: {
                return "SET_REQUEST_PDU";
            }
            case 164: {
                return "TRAP_PDU";
            }
        }
        return "UNKNOWN";
    }
}

