/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.http.AbstractCauchoRequest;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoRequestWrapper;
import com.caucho.server.webapp.WebApp;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;

public class DispatchFilterChain
implements FilterChain {
    private FilterChain _next;
    private WebApp _webApp;
    private ClassLoader _classLoader;
    private ServletRequestListener[] _requestListeners;

    public DispatchFilterChain(FilterChain next, WebApp webApp) {
        this._next = next;
        this._webApp = webApp;
        if (webApp != null) {
            this._classLoader = webApp.getClassLoader();
            this._requestListeners = webApp.getRequestListeners();
        } else {
            this._classLoader = Thread.currentThread().getContextClassLoader();
            this._requestListeners = new ServletRequestListener[0];
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletContext webApp;
        CauchoRequest cReq;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        if (request instanceof CauchoRequestWrapper) {
            cReq = (CauchoRequestWrapper)request;
            webApp = ((CauchoRequestWrapper)cReq).getRequest().getServletContext();
        } else {
            webApp = request instanceof AbstractCauchoRequest ? (((AbstractCauchoRequest)(cReq = (AbstractCauchoRequest)request)).getRequest() != null ? ((AbstractCauchoRequest)cReq).getRequest().getServletContext() : cReq.getServletContext()) : request.getServletContext();
        }
        try {
            thread.setContextClassLoader(this._classLoader);
            if (webApp != this._webApp) {
                for (int i = 0; i < this._requestListeners.length; ++i) {
                    ServletRequestEvent event = new ServletRequestEvent((ServletContext)this._webApp, request);
                    this._requestListeners[i].requestInitialized(event);
                }
            }
            this._next.doFilter(request, response);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        finally {
            if (webApp != this._webApp) {
                for (int i = this._requestListeners.length - 1; i >= 0; --i) {
                    ServletRequestEvent event = new ServletRequestEvent((ServletContext)this._webApp, request);
                    this._requestListeners[i].requestDestroyed(event);
                }
            }
            thread.setContextClassLoader(oldLoader);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._next + "]";
    }
}

