/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.webapp.CauchoFilterChain;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.transaction.UserTransactionImpl;
import com.caucho.transaction.UserTransactionProxy;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class WebAppFilterChain
implements CauchoFilterChain {
    private static final Logger log = Logger.getLogger(WebAppFilterChain.class.getName());
    private FilterChain _next;
    private WebApp _webApp;
    private TransactionManagerImpl _tm;
    private UserTransactionProxy _utm;
    private ErrorPageManager _errorPageManager;
    private boolean _isTop = true;

    public WebAppFilterChain(FilterChain next, WebApp app) {
        this(next, app, true);
    }

    public WebAppFilterChain(FilterChain next, WebApp webApp, boolean isTop) {
        this._next = next;
        this._webApp = webApp;
        this._errorPageManager = webApp.getErrorPageManager();
        this._isTop = isTop;
        try {
            if (this._isTop) {
                this._tm = TransactionManagerImpl.getInstance();
                this._utm = UserTransactionProxy.getInstance();
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public FilterChain getNext() {
        return this._next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        WebApp webApp = this._webApp;
        UserTransactionImpl ut = null;
        if (this._isTop) {
            ut = this._utm.getUserTransaction();
        }
        try {
            thread.setContextClassLoader(webApp.getClassLoader());
            if (!webApp.enterWebApp() && webApp.getConfigException() == null) {
                if (response instanceof HttpServletResponse) {
                    HttpServletResponse res = (HttpServletResponse)response;
                    res.sendError(503);
                }
                return;
            }
            this._next.doFilter(request, response);
        }
        catch (Throwable e) {
            this._errorPageManager.sendServletError(e, request, response);
        }
        finally {
            webApp.exitWebApp();
            if (request instanceof HttpServletRequestImpl) {
                ((HttpServletRequestImpl)request).finishInvocation();
            }
            if (this._isTop) {
                ((CauchoResponse)response).close();
                try {
                    if (ut != null) {
                        ut.abortTransaction();
                    }
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            thread.setContextClassLoader(oldLoader);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._webApp.getURL() + ", next=" + this._next + "]";
    }
}

