/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.ConnectionWrapper;
import com.caucho.tools.profiler.ProfilerPoint;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

public class DriverWrapper
implements Driver {
    private final ProfilerPoint _profilerPoint;
    private final Driver _driver;

    public DriverWrapper(ProfilerPoint profilerPoint, Driver driver) {
        this._profilerPoint = profilerPoint;
        this._driver = driver;
    }

    private Connection wrap(Connection connection) {
        return new ConnectionWrapper(this._profilerPoint, connection);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.wrap(this._driver.connect(url, info));
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this._driver.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this._driver.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return this._driver.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this._driver.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return this._driver.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    public String toString() {
        return "DriverWrapper[" + this._profilerPoint.getName() + "]";
    }
}

