/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.ReadStream;
import java.io.BufferedReader;
import java.io.IOException;

public class BufferedReaderAdapter
extends BufferedReader {
    private ReadStream _rs;
    private BufferedReader _bufferedReader;

    public BufferedReaderAdapter(ReadStream rs) {
        super(rs.getReader(), 1);
    }

    public void init(ReadStream rs) {
        this._rs = rs;
        this._bufferedReader = null;
    }

    @Override
    public int read() throws IOException {
        BufferedReader reader = this._bufferedReader;
        if (reader != null) {
            return reader.read();
        }
        return this._rs.readChar();
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        BufferedReader reader = this._bufferedReader;
        if (reader != null) {
            return reader.read(cbuf, offset, length);
        }
        return this._rs.read(cbuf, offset, length);
    }

    @Override
    public String readLine() throws IOException {
        BufferedReader reader = this._bufferedReader;
        if (reader != null) {
            return reader.readLine();
        }
        return this._rs.readln();
    }

    @Override
    public long skip(long n) throws IOException {
        long count;
        BufferedReader reader = this._bufferedReader;
        if (reader != null) {
            return reader.skip(n);
        }
        for (count = 0L; count < n && this._rs.readChar() >= 0; ++count) {
        }
        return count;
    }

    @Override
    public boolean ready() throws IOException {
        BufferedReader reader = this._bufferedReader;
        if (reader != null) {
            return reader.ready();
        }
        return this._rs.available() > 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAhead) throws IOException {
        BufferedReader reader = this._bufferedReader;
        if (reader == null) {
            this._bufferedReader = reader = new BufferedReader(this._rs.getReader());
        }
        reader.mark(readAhead);
    }

    @Override
    public void reset() throws IOException {
        BufferedReader reader = this._bufferedReader;
        if (reader != null) {
            reader.reset();
        }
    }

    @Override
    public void close() throws IOException {
        BufferedReader reader = this._bufferedReader;
        this._bufferedReader = null;
        if (reader != null) {
            reader.close();
        }
    }
}

