/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.loader.DynamicClassLoader;
import com.caucho.make.DependencyList;
import com.caucho.server.util.CauchoSystem;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.NotFoundPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.RandomAccessStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class MergePath
extends FilesystemPath {
    private ArrayList<Path> _pathList;

    public MergePath() {
        this(null, "/", null, "/");
    }

    public MergePath(String userPath, String path, Path ... paths) {
        this(null, userPath, null, path);
        if (paths != null) {
            for (Path p : paths) {
                this.addMergePath(p);
            }
        }
    }

    public MergePath(Path ... paths) {
        this(paths[0].getUserPath(), paths[0].getFullPath(), paths);
    }

    protected MergePath(MergePath root, String userPath, Map<String, Object> attributes, String path) {
        super(root, userPath, path);
        if (root == null) {
            this._root = this;
            this._pathList = new ArrayList();
        }
    }

    @Override
    public Path schemeWalk(String userPath, Map<String, Object> attributes, String filePath, int offset) {
        int head;
        int length = filePath.length();
        if (length <= offset || filePath.charAt(offset) != '(') {
            return super.schemeWalk(userPath, attributes, filePath, offset);
        }
        MergePath mergePath = this.createMergePath();
        mergePath.setUserPath(userPath);
        int tail = head = ++offset;
        while (tail < length) {
            char ch = filePath.charAt(tail);
            if (ch == ')') {
                if (head + 1 != tail) {
                    String subPath = filePath.substring(head, tail);
                    if (subPath.startsWith("(") && subPath.endsWith(")")) {
                        subPath = subPath.substring(1, subPath.length() - 1);
                    }
                    mergePath.addMergePath(Vfs.lookup(subPath));
                }
                if (tail + 1 == length) {
                    return mergePath;
                }
                return mergePath.fsWalk(userPath, attributes, filePath.substring(tail + 1));
            }
            if (ch == ';') {
                String subPath = filePath.substring(head, tail);
                if (subPath.startsWith("(") && subPath.endsWith(")")) {
                    subPath = subPath.substring(1, subPath.length() - 1);
                }
                mergePath.addMergePath(Vfs.lookup(subPath));
                head = ++tail;
                continue;
            }
            if (ch == '(') {
                int depth = 1;
                ++tail;
                while (tail < length) {
                    if (filePath.charAt(tail) == '(') {
                        ++depth;
                    } else if (filePath.charAt(tail) == ')') {
                        ++tail;
                        if (--depth == 0) break;
                    }
                    ++tail;
                }
                if (depth == 0) continue;
                return new NotFoundPath(this.getSchemeMap(), filePath);
            }
            ++tail;
        }
        return new NotFoundPath(this.getSchemeMap(), filePath);
    }

    protected MergePath createMergePath() {
        return new MergePath();
    }

    public void addMergePath(Path path) {
        if (!(path instanceof MergePath)) {
            ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
            if (!pathList.contains(path)) {
                pathList.add(path);
            }
        } else {
            if (((MergePath)path)._root == this._root) {
                return;
            }
            MergePath mergePath = (MergePath)path;
            ArrayList<Path> subPaths = mergePath.getMergePaths();
            String pathName = "./" + mergePath._pathname + "/";
            for (int i = 0; i < subPaths.size(); ++i) {
                Path subPath = subPaths.get(i);
                this.addMergePath(subPath.lookup(pathName));
            }
        }
    }

    public void addClassPath() {
        this.addClassPath(Thread.currentThread().getContextClassLoader());
    }

    public void addClassPath(ClassLoader loader) {
        String classpath = null;
        classpath = loader instanceof DynamicClassLoader ? ((DynamicClassLoader)loader).getClassPath() : CauchoSystem.getClassPath();
        this.addClassPath(classpath);
    }

    public void addResourceClassPath(ClassLoader loader) {
        String classpath = null;
        classpath = loader instanceof DynamicClassLoader ? ((DynamicClassLoader)loader).getResourcePathSpecificFirst() : CauchoSystem.getClassPath();
        this.addClassPath(classpath);
    }

    public void addLocalClassPath() {
        this.addLocalClassPath(Thread.currentThread().getContextClassLoader());
    }

    public void addLocalClassPath(ClassLoader loader) {
        String classpath = null;
        classpath = loader instanceof DynamicClassLoader ? ((DynamicClassLoader)loader).getLocalClassPath() : System.getProperty("java.class.path");
        this.addClassPath(classpath);
    }

    public void addClassPath(String classpath) {
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        while (head < classpath.length()) {
            tail = classpath.indexOf(sep, head);
            String segment = null;
            if (tail < 0) {
                segment = classpath.substring(head);
                head = classpath.length();
            } else {
                segment = classpath.substring(head, tail);
                head = tail + 1;
            }
            if (segment.equals("")) continue;
            if (segment.endsWith(".jar") || segment.endsWith(".zip")) {
                this.addMergePath(JarPath.create(Vfs.lookup(segment)));
                continue;
            }
            this.addMergePath(Vfs.lookup(segment));
        }
    }

    public ArrayList<Path> getMergePaths() {
        return ((MergePath)this._root)._pathList;
    }

    @Override
    public Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        ArrayList<Path> pathList = this.getMergePaths();
        if (!userPath.startsWith("/") || pathList.size() == 0) {
            return new MergePath((MergePath)this._root, userPath, attributes, path);
        }
        String bestPrefix = null;
        for (int i = 0; i < pathList.size(); ++i) {
            Path subPath = pathList.get(i);
            String prefix = subPath.getPath();
            if (!path.startsWith(prefix) || bestPrefix != null && bestPrefix.length() >= prefix.length()) continue;
            bestPrefix = prefix;
        }
        if (bestPrefix != null) {
            if (!(path = path.substring(bestPrefix.length())).startsWith("/")) {
                path = "/" + path;
            }
            return new MergePath((MergePath)this._root, userPath, attributes, path);
        }
        return pathList.get(0).lookup(userPath, attributes);
    }

    @Override
    public String getScheme() {
        return this.getBestPath().getScheme();
    }

    @Override
    public String getRelativePath() {
        if (this._pathname.startsWith("/")) {
            return "." + this._pathname;
        }
        return this._pathname;
    }

    @Override
    public boolean exists() {
        return this.getBestPath().exists();
    }

    @Override
    public int getMode() {
        return this.getBestPath().getMode();
    }

    @Override
    public boolean isExecutable() {
        return this.getBestPath().isExecutable();
    }

    @Override
    public boolean isDirectory() {
        return this.getBestPath().isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.getBestPath().isFile();
    }

    @Override
    public long getLength() {
        return this.getBestPath().getLength();
    }

    @Override
    public long getLastModified() {
        return this.getBestPath().getLastModified();
    }

    @Override
    public boolean canRead() {
        return this.getBestPath().canRead();
    }

    @Override
    public boolean canWrite() {
        return this.getBestPath().canRead();
    }

    @Override
    public ArrayList<Path> getResources(String pathName) {
        ArrayList<Path> list = new ArrayList<Path>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            path = path.lookup(pathname);
            ArrayList<Path> subResources = path.getResources(pathName);
            for (int j = 0; j < subResources.size(); ++j) {
                Path newPath = subResources.get(j);
                if (list.contains(newPath)) continue;
                list.add(newPath);
            }
        }
        return list;
    }

    @Override
    public ArrayList<Path> getResources() {
        ArrayList<Path> list = new ArrayList<Path>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            path = path.lookup(pathname);
            ArrayList<Path> subResources = path.getResources();
            for (int j = 0; j < subResources.size(); ++j) {
                Path newPath = subResources.get(j);
                if (list.contains(newPath)) continue;
                list.add(newPath);
            }
        }
        return list;
    }

    @Override
    public String[] list() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            if (!(path = path.lookup(pathname)).isDirectory()) continue;
            String[] subList = path.list();
            for (int j = 0; subList != null && j < subList.length; ++j) {
                if (list.contains(subList[j])) continue;
                list.add(subList[j]);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean mkdir() throws IOException {
        return this.getWritePath().mkdir();
    }

    @Override
    public boolean mkdirs() throws IOException {
        return this.getWritePath().mkdirs();
    }

    @Override
    public boolean remove() throws IOException {
        return this.getBestPath().remove();
    }

    @Override
    public boolean renameTo(Path path) throws IOException {
        return this.getBestPath().renameTo(path);
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        StreamImpl stream = this.getBestPath().openReadImpl();
        stream.setPath(this);
        return stream;
    }

    @Override
    public StreamImpl openWriteImpl() throws IOException {
        StreamImpl stream = this.getWritePath().openWriteImpl();
        stream.setPath(this);
        return stream;
    }

    @Override
    public StreamImpl openReadWriteImpl() throws IOException {
        StreamImpl stream = this.getWritePath().openReadWriteImpl();
        stream.setPath(this);
        return stream;
    }

    @Override
    public StreamImpl openAppendImpl() throws IOException {
        StreamImpl stream = this.getWritePath().openAppendImpl();
        stream.setPath(this);
        return stream;
    }

    @Override
    public RandomAccessStream openFileRandomAccess() throws IOException {
        RandomAccessStream stream = this.getWritePath().openFileRandomAccess();
        return stream;
    }

    public Path getWritePath() {
        ArrayList<Path> pathList = this.getPathList();
        if (pathList.size() == 0) {
            return new NotFoundPath(this.getSchemeMap(), this._pathname);
        }
        return pathList.get(0);
    }

    @Override
    public PersistentDependency createDepend() {
        ArrayList<Path> pathList = ((MergePath)this._root)._pathList;
        if (pathList.size() == 1) {
            return pathList.get(0).createDepend();
        }
        DependencyList dependList = new DependencyList();
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            Path realPath = path.lookup(this._pathname);
            dependList.add(realPath.createDepend());
        }
        return dependList;
    }

    public Path getBestPath() {
        ArrayList<Path> pathList = this.getPathList();
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = pathList.get(i);
            if (!path.exists()) continue;
            return path;
        }
        if (pathList.size() > 0) {
            return pathList.get(0);
        }
        return new NotFoundPath(this.getSchemeMap(), this._userPath);
    }

    protected ArrayList<Path> getPathList() {
        if (this._pathList == null) {
            String pathname = this._pathname;
            if (pathname.startsWith("/")) {
                pathname = "." + pathname;
            }
            ArrayList<Path> pathList = new ArrayList<Path>();
            ArrayList<Path> rootPathList = ((MergePath)this._root)._pathList;
            for (int i = 0; i < rootPathList.size(); ++i) {
                Path rootPath = rootPathList.get(i);
                Path realPath = rootPath.lookup(pathname);
                realPath.setUserPath(this._userPath);
                pathList.add(realPath);
            }
            this._pathList = pathList;
        }
        return this._pathList;
    }

    @Override
    public Path copy() {
        MergePath root = (MergePath)this._root;
        root = root == this ? null : (MergePath)root.copy();
        MergePath copy = new MergePath(root, this._userPath, null, this._pathname);
        ArrayList<Path> pathList = this.getPathList();
        for (Path path : pathList) {
            copy.addMergePath(path.copy());
        }
        return copy;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._pathname + "]";
    }
}

