/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import com.caucho.util.CharBuffer;
import com.caucho.xml2.QAttributes;
import com.caucho.xml2.XMLWriter;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXBuilder
implements XMLWriter,
Locator {
    private XMLReader _saxReader;
    private ContentHandler _contentHandler;
    private QAttributes _attributes;
    private CharBuffer _text = new CharBuffer();
    private boolean _escapeText;
    private boolean _hasElement;
    private String _elementUri;
    private String _elementLocalName;
    private String _elementQName;
    private String _filename;
    private int _line;
    private String _elementSystemId;
    private int _elementLine;
    private Locator _locator;

    public SAXBuilder() {
        this._attributes = new QAttributes();
    }

    public SAXBuilder(XMLReader saxReader) {
        this();
        this.init(saxReader);
    }

    public void init(XMLReader saxReader) {
        this._saxReader = saxReader;
        this._contentHandler = saxReader.getContentHandler();
        this.init();
    }

    public void init() {
        this._text.clear();
        this._attributes.clear();
        this._hasElement = false;
        this._filename = null;
        this._line = 0;
    }

    public void setContentHandler(ContentHandler handler) {
        this._contentHandler = handler;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    @Override
    public void startDocument() throws IOException, SAXException {
        this._contentHandler.setDocumentLocator(this);
        this._contentHandler.startDocument();
    }

    @Override
    public void endDocument() throws IOException, SAXException {
        this.pop();
        this._contentHandler.endDocument();
    }

    public void setLocation(String filename, int line, int column) {
        this._filename = filename;
        this._line = line;
    }

    @Override
    public String getSystemId() {
        if (this._elementSystemId != null) {
            return this._elementSystemId;
        }
        if (this._locator != null) {
            return this._locator.getSystemId();
        }
        return this._filename;
    }

    @Override
    public String getPublicId() {
        if (this._locator != null) {
            return this._locator.getPublicId();
        }
        return null;
    }

    @Override
    public int getLineNumber() {
        if (this._elementSystemId != null) {
            return this._elementLine;
        }
        if (this._locator != null) {
            return this._locator.getLineNumber();
        }
        return 0;
    }

    @Override
    public int getColumnNumber() {
        if (this._locator != null) {
            return this._locator.getColumnNumber();
        }
        return 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName) throws IOException, SAXException {
        this.pop();
        this._elementUri = uri;
        this._elementLocalName = localName;
        this._elementQName = qName;
        this._hasElement = true;
        if (this._locator != null) {
            this._elementSystemId = this._locator.getSystemId();
            this._elementLine = this._locator.getLineNumber();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws IOException, SAXException {
        this._contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws IOException, SAXException {
        this._contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void attribute(String uri, String localName, String qName, String value) throws IOException, SAXException {
        QName name = new QName(qName, uri);
        this._attributes.add(name, value);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws IOException, SAXException {
        this.pop();
        if (uri != null) {
            this._contentHandler.endElement(uri, localName, qName);
        } else {
            this._contentHandler.endElement("", null, qName);
        }
    }

    @Override
    public void processingInstruction(String name, String data) throws IOException, SAXException {
        this.pop();
        this._contentHandler.processingInstruction(name, data);
    }

    @Override
    public void comment(String data) throws IOException, SAXException {
        this.pop();
    }

    @Override
    public boolean getEscapeText() {
        return this._escapeText;
    }

    @Override
    public void setEscapeText(boolean isEscaped) {
        this._escapeText = isEscaped;
    }

    @Override
    public void text(String text) throws IOException, SAXException {
        this.popElement();
        this._text.append(text);
    }

    @Override
    public void text(char[] buffer, int offset, int length) throws IOException, SAXException {
        this.popElement();
        this._text.append(buffer, offset, length);
    }

    @Override
    public void cdata(String text) throws IOException, SAXException {
        this.popElement();
        this.text(text);
    }

    @Override
    public void cdata(char[] buffer, int offset, int length) throws IOException, SAXException {
        this.popElement();
        this.text(buffer, offset, length);
    }

    private void pop() throws IOException, SAXException {
        this.popElement();
        if (this._text.length() == 0) {
            return;
        }
        this._contentHandler.characters(this._text.getBuffer(), 0, this._text.getLength());
        this._text.clear();
    }

    private void popElement() throws IOException, SAXException {
        if (this._hasElement) {
            if (this._elementUri == null) {
                this._contentHandler.startElement("", null, this._elementQName, this._attributes);
            } else {
                this._contentHandler.startElement(this._elementUri, this._elementLocalName, this._elementQName, this._attributes);
            }
            this._hasElement = false;
            this._elementSystemId = null;
            this._attributes.clear();
        }
    }
}

