/*
 * Copyright (c) 1998-2018 Caucho Technology -- all rights reserved
 *
 * This file is part of Resin(R) Open Source
 *
 * Each copy or derived work must preserve the copyright notice and this
 * notice unmodified.
 *
 * Resin Open Source is software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Resin Open Source is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, or any warranty
 * of NON-INFRINGEMENT.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Resin Open Source; if not, write to the
 *
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330
 *   Boston, MA 02111-1307  USA
 *
 * @author Scott Ferguson
 */

package com.caucho.network.listen;

import com.caucho.inject.Module;

/**
 * The thread task to handle a newly accepted request.
 */
@Module
class TcpSocketAcceptThread implements Runnable
{
  private final SocketLinkThreadLauncher _launcher;
  
  TcpSocketAcceptThread(SocketLinkThreadLauncher launcher)
  {
    _launcher = launcher;
  }

  @Override
  public void run()
  {
    Thread thread = Thread.currentThread();
    String oldThreadName = thread.getName();
    
    SocketLinkThreadLauncher launcher = _launcher;
    String threadName = launcher.generateThreadName() + "-" + thread.getId();
    thread.setName(threadName);

    try {
      launcher.onChildIdleBegin();
      launcher.onChildThreadLaunchBegin();
      
      launcher.handleTasks(false);
    } finally {
      launcher.onChildIdleEnd();
      launcher.onChildThreadLaunchEnd();
      
      thread.setName(oldThreadName);
    }
  }
}
