/*
 * Copyright (c) 1998-2018 Caucho Technology -- all rights reserved
 *
 * This file is part of Resin(R) Open Source
 *
 * Each copy or derived work must preserve the copyright notice and this
 * notice unmodified.
 *
 * Resin Open Source is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Resin Open Source is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, or any warranty
 * of NON-INFRINGEMENT.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Resin Open Source; if not, write to the
 *   Free SoftwareFoundation, Inc.
 *   59 Temple Place, Suite 330
 *   Boston, MA 02111-1307  USA
 *
 * @author Scott Ferguson
 */

package com.caucho.xml2;

/**
 * Symbols for HTML using Latin-1 (ISO-8859-1)
 */
class HtmlLatin1 {
  private void entity(String name, int ch)
  {
  }

  private void init()
  {
    entity("nbsp", 160);
    entity("iexcl", 161);
    entity("cent", 162);
    entity("pound", 163);
    entity("curren", 164);
    entity("yen", 165);
    entity("brvbar", 166);
    entity("sect", 167);
    entity("uml", 168);
    entity("copy", 169);
    entity("ordf", 170);
    entity("laquo", 171);
    entity("not", 172);
    entity("shy", 173);
    entity("reg", 174);
    entity("macr", 175);
    entity("deg", 176);
    entity("plusmn", 177);
    entity("sup2", 178);
    entity("sup3", 179);
    entity("acute", 180);
    entity("micro", 181);
    entity("para", 182);
    entity("middot", 183);
    entity("cedil", 184);
    entity("sup1", 185);
    entity("ordm", 186);
    entity("raquo", 187);
    entity("frac14", 188);
    entity("frac12", 189);
    entity("frac34", 190);
    entity("iquest", 191);
    entity("Agrave", 192);
    entity("Aacute", 193);
    entity("Acirc", 194);
    entity("Atilde", 195);
    entity("Auml", 196);
    entity("Aring", 197);
    entity("AElig", 198);
    entity("Ccedil", 199);
    entity("Egrave", 200);
    entity("Eacute", 201);
    entity("Ecirc", 202);
    entity("Euml", 203);
    entity("Igrave", 204);
    entity("Iacute", 205);
    entity("Icirc", 206);
    entity("Iuml", 207);
    entity("ETH", 208);
    entity("Ntilde", 209);
    entity("Ograve", 210);
    entity("Oacute", 211);
    entity("Ocirc", 212);
    entity("Otilde", 213);
    entity("Ouml", 214);
    entity("times", 215);
    entity("Oslash", 216);
    entity("Ugrave", 217);
    entity("Uacute", 218);
    entity("Ucirc", 219);
    entity("Uuml", 220);
    entity("Yacute", 221);
    entity("THORN", 222);
    entity("szlig", 223);
    entity("agrave", 224);
    entity("aacute", 225);
    entity("acirc", 226);
    entity("atilde", 227);
    entity("auml", 228);
    entity("aring", 229);
    entity("aelig", 230);
    entity("ccedil", 231);
    entity("egrave", 232);
    entity("eacute", 233);
    entity("ecirc", 234);
    entity("euml", 235);
    entity("igrave", 236);
    entity("iacute", 237);
    entity("icirc", 238);
    entity("iuml", 239);
    entity("eth", 240);
    entity("ntilde", 241);
    entity("ograve", 242);
    entity("oacute", 243);
    entity("ocirc", 244);
    entity("otilde", 245);
    entity("ouml", 246);
    entity("divide", 247);
    entity("oslash", 248);
    entity("ugrave", 249);
    entity("uacute", 250);
    entity("ucirc", 251);
    entity("uuml", 252);
    entity("yacute", 253);
    entity("thorn", 254);
    entity("yuml", 255);
  }
}
