/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.thread;

import com.caucho.admin.thread.ThreadActivityGroup;
import com.caucho.admin.thread.ThreadSnapshot;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.ServerMXBean;
import com.caucho.management.server.TcpConnectionInfo;
import com.caucho.server.cluster.ServletService;
import com.caucho.util.L10N;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public abstract class AbstractThreadActivityReport {
    private static final Logger log = Logger.getLogger(AbstractThreadActivityReport.class.getName());
    private static final L10N L = new L10N(AbstractThreadActivityReport.class);

    public ThreadActivityGroup[] execute(boolean greedy) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(true, true);
        if (threadInfos == null || threadInfos.length == 0) {
            log.fine(L.l("execute failed: ThreadMXBean.dumpAllThreads produced no results"));
            return null;
        }
        ThreadSnapshot[] threads = this.createThreadSnapshots(threadInfos);
        ThreadActivityGroup[] groups = this.partitionThreads(threads, greedy);
        return groups;
    }

    protected abstract ThreadActivityGroup[] createGroups();

    protected abstract boolean assignActivityCode(ThreadSnapshot var1);

    public abstract Map<Character, String> getScoreboardKey();

    private ThreadSnapshot[] createThreadSnapshots(ThreadInfo[] threadInfos) {
        Map<Long, TcpConnectionInfo> connectionsById = this.getConnectionsById();
        ThreadSnapshot[] threads = new ThreadSnapshot[threadInfos.length];
        for (int i = 0; i < threadInfos.length; ++i) {
            threads[i] = new ThreadSnapshot(threadInfos[i]);
            TcpConnectionInfo connectionInfo = connectionsById.get(threadInfos[i].getThreadId());
            if (connectionInfo != null) {
                threads[i].setConnectionInfo(connectionInfo);
            }
            this.assignActivityCode(threads[i]);
        }
        return threads;
    }

    private Map<Long, TcpConnectionInfo> getConnectionsById() {
        PortMXBean[] ports;
        ServerMXBean serverAdmin;
        HashMap<Long, TcpConnectionInfo> connectionInfoMap = new HashMap<Long, TcpConnectionInfo>();
        ServletService servletService = ServletService.getCurrent();
        if (servletService != null && (serverAdmin = servletService.getAdmin()) != null && (ports = serverAdmin.getPorts()) != null && ports.length > 0) {
            for (PortMXBean port : ports) {
                TcpConnectionInfo[] connectionInfos = port.connectionInfo();
                if (connectionInfos == null || connectionInfos.length <= 0) continue;
                for (TcpConnectionInfo connectionInfo : connectionInfos) {
                    long threadId = connectionInfo.getThreadId();
                    connectionInfoMap.put(threadId, connectionInfo);
                }
            }
        }
        return connectionInfoMap;
    }

    private ThreadActivityGroup[] partitionThreads(ThreadSnapshot[] threads, boolean greedy) {
        ThreadActivityGroup[] groups = this.createGroups();
        for (ThreadSnapshot thread : threads) {
            ThreadActivityGroup group;
            boolean added;
            ThreadActivityGroup[] threadActivityGroupArray = groups;
            int n = threadActivityGroupArray.length;
            for (int i = 0; !(i >= n || (added = (group = threadActivityGroupArray[i]).addIfMatches(thread)) && greedy); ++i) {
            }
        }
        return groups;
    }
}

