/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.BooleanType;
import com.caucho.util.CharBuffer;

public class LikeExpr
extends AbstractAmberExpr {
    private AmberExpr _expr;
    private AmberExpr _value;
    private String _escape;
    private boolean _isNot;

    public LikeExpr(AmberExpr expr, AmberExpr value, String escape, boolean isNot) {
        this._expr = expr;
        this._value = value;
        this._isNot = isNot;
        this._escape = escape;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public AmberType getType() {
        return BooleanType.create();
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        this._expr = this._expr.bindSelect(parser);
        this._value = this._value.bindSelect(parser);
        return this;
    }

    @Override
    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return this._expr.usesFrom(from, type);
    }

    @Override
    public AmberExpr replaceJoin(JoinExpr join) {
        this._expr = this._expr.replaceJoin(join);
        this._value = this._value.replaceJoin(join);
        return this;
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    @Override
    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append('(');
        cb.append(this._expr);
        if (this._isNot) {
            cb.append(" NOT");
        }
        cb.append(" LIKE ");
        cb.append(this._value);
        cb.append(')');
        return cb.close();
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        cb.append('(');
        if (select) {
            this._expr.generateWhere(cb);
        } else {
            this._expr.generateUpdateWhere(cb);
        }
        if (this._isNot) {
            cb.append(" NOT");
        }
        cb.append(" LIKE ");
        if (select) {
            this._value.generateWhere(cb);
        } else {
            this._value.generateUpdateWhere(cb);
        }
        if (this._escape != null) {
            cb.append(" ESCAPE ");
            cb.append(this._escape);
        }
        cb.append(')');
    }
}

