/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AmberColumnExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.IdExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.expr.KeyColumnExpr;
import com.caucho.amber.expr.OneToManyJoinExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.util.CharBuffer;

public class ManyToOneJoinExpr
extends JoinExpr {
    private LinkColumns _linkColumns;
    private FromItem _sourceFromItem;
    private FromItem _targetFromItem;

    public ManyToOneJoinExpr(LinkColumns link, FromItem source, FromItem target) {
        this._linkColumns = link;
        this._sourceFromItem = source;
        this._targetFromItem = target;
        if (target == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    public boolean isManyToMany() {
        if (this._sourceFromItem == null) {
            return false;
        }
        return this._sourceFromItem.getJoinExpr() instanceof OneToManyJoinExpr;
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        return this;
    }

    @Override
    public boolean bindToFromItem() {
        if (this._targetFromItem.getJoinExpr() == null || this._targetFromItem.getJoinExpr().equals(this)) {
            this._targetFromItem.setJoinExpr(this);
            return true;
        }
        if (this._sourceFromItem.getJoinExpr() == null) {
            this._sourceFromItem.setJoinExpr(new OneToManyJoinExpr(this._linkColumns, this._sourceFromItem, this._targetFromItem));
            return true;
        }
        return false;
    }

    @Override
    public FromItem getJoinTarget() {
        return this._targetFromItem;
    }

    @Override
    public FromItem getJoinParent() {
        return this._sourceFromItem;
    }

    @Override
    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return from == this._targetFromItem || from == this._sourceFromItem;
    }

    @Override
    public boolean exists(FromItem from) {
        return false;
    }

    @Override
    public AmberExpr replace(KeyColumnExpr id) {
        PathExpr parent = id.getParent();
        if (parent.getChildFromItem() != this._targetFromItem) {
            return id;
        }
        ForeignColumn sourceColumn = this._linkColumns.getSourceColumn(id.getColumn());
        if (sourceColumn == null) {
            throw new IllegalStateException(id.getColumn().getName());
        }
        return new AmberColumnExpr(this._sourceFromItem.getIdExpr(), sourceColumn);
    }

    @Override
    public AmberExpr replace(IdExpr id) {
        return id;
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        String sourceName = null;
        if (this._sourceFromItem != null) {
            sourceName = this._sourceFromItem.getName();
        }
        String targetName = this._targetFromItem.getName();
        cb.append(this._linkColumns.generateWhere(sourceName, targetName));
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateWhere(cb);
    }

    @Override
    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    @Override
    public void generateJoin(CharBuffer cb) {
        cb.append(this._linkColumns.generateJoin(this._sourceFromItem.getName(), this._targetFromItem.getName()));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManyToOneJoinExpr)) {
            return false;
        }
        ManyToOneJoinExpr joinExpr = (ManyToOneJoinExpr)o;
        return this._linkColumns.equals(joinExpr._linkColumns) && this._sourceFromItem.equals(joinExpr._sourceFromItem) && this._targetFromItem.equals(joinExpr._targetFromItem);
    }

    public String toString() {
        return "ManyToOneJoinExpr[" + this._linkColumns + "," + this._sourceFromItem + "," + this._targetFromItem + "]";
    }
}

