/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractPathExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.OneToManyJoinExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EntityType;
import com.caucho.util.CharBuffer;

public class OneToManyExpr
extends AbstractPathExpr {
    private PathExpr _parent;
    private LinkColumns _linkColumns;
    private FromItem _fromItem;
    private FromItem _childFromItem;

    public OneToManyExpr(QueryParser parser, PathExpr parent, LinkColumns linkColumns) {
        this._parent = parent;
        this._linkColumns = linkColumns;
    }

    public LinkColumns getLinkColumns() {
        return this._linkColumns;
    }

    @Override
    public AmberType getType() {
        return this._linkColumns.getSourceTable().getType();
    }

    @Override
    public EntityType getTargetType() {
        return (EntityType)this.getType();
    }

    @Override
    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return from == this._childFromItem || type == 1 && this._parent.usesFrom(from, type);
    }

    public PathExpr getParent() {
        return this._parent;
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        return this.bindSelect(parser, null);
    }

    @Override
    public PathExpr bindSelect(QueryParser parser, String id) {
        if (this._fromItem != null) {
            return this;
        }
        this._fromItem = this._parent.bindSubPath(parser);
        AmberTable sourceTable = this._linkColumns.getSourceTable();
        this._childFromItem = parser.addFromItem(sourceTable, id);
        OneToManyJoinExpr joinExpr = new OneToManyJoinExpr(this._linkColumns, this._childFromItem, this._fromItem);
        this._childFromItem.setJoinExpr(joinExpr);
        this._childFromItem.setCollectionExpr(this);
        return this;
    }

    @Override
    public FromItem getChildFromItem() {
        return this._childFromItem;
    }

    @Override
    public FromItem bindSubPath(QueryParser parser) {
        if (this._childFromItem == null) {
            this.bindSelect(parser, null);
        }
        return this._childFromItem;
    }

    public AmberTable getTable() {
        return this._fromItem.getTable();
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        throw new IllegalStateException(this.getClass().getName());
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateWhere(cb);
    }

    @Override
    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    @Override
    public void generateSelect(CharBuffer cb) {
        String id = this._childFromItem.getName();
        cb.append(this._linkColumns.generateSelectSQL(id));
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        OneToManyExpr oneToMany = (OneToManyExpr)o;
        return this._parent.equals(oneToMany._parent) && this._linkColumns.equals(oneToMany._linkColumns);
    }

    public String toString() {
        return "OneToManyExpr[" + this._parent + "," + this._linkColumns + "]";
    }
}

