/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.PropertyField;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.logging.Logger;

public class VersionField
extends PropertyField {
    private static final L10N L = new L10N(VersionField.class);
    private static final Logger log = Logger.getLogger(VersionField.class.getName());

    public VersionField(EntityType entityType, String name) throws ConfigException {
        super(entityType, name);
        this.setLazy(false);
    }

    public VersionField(EntityType entityType) {
        super(entityType);
        this.setLazy(false);
    }

    public String generateIsNull() {
        String getter = this.generateSuperGetter("this");
        AmberType type = this.getColumn().getType();
        return type.generateIsNull(getter);
    }

    public void generateIncrementVersion(JavaWriter out) throws IOException {
        int dirtyGroup = this.getIndex() / 64;
        String dirtyVar = "__caucho_dirtyMask_" + dirtyGroup;
        long dirtyMask = 1L << this.getIndex() % 64;
        String getter = this.generateSuperGetter("this");
        AmberType type = this.getColumn().getType();
        out.println();
        out.println("if (" + this.generateIsNull() + ")");
        if (type.getJavaTypeName().equals(Timestamp.class.getName())) {
            out.println("  " + this.generateSuperSetter("this", "new java.sql.Timestamp(com.caucho.util.Alarm.getExactTime())") + ";");
        } else {
            out.println("  " + this.generateSuperSetter("this", "new Integer(1)") + ";");
        }
        out.println("else");
        out.println("  " + this.generateSuperSetter("this", type.generateIncrementVersion(getter)) + ";");
        out.println();
        out.println("long oldMask = " + dirtyVar + ";");
        out.println(dirtyVar + " |= " + dirtyMask + "L;");
        out.println();
        out.println("if (__caucho_session != null && oldMask == 0)");
        out.println("  __caucho_session.update(this);");
    }

    public String generateMatchArgWhere(String id) {
        return this.getColumn().generateMatchArgWhere(id);
    }

    @Override
    public void generatePostConstructor(JavaWriter out) throws IOException {
        String setter = this.getSetterName();
        String typeName = this.getJavaTypeName();
        Object initialValue = this.getColumn().getType().toObject(1L);
        out.println("if (" + this.generateIsNull() + ");");
        out.println("  __caucho_increment_version();");
    }

    public void generateSetVersion(JavaWriter out, String pstmt, String index) throws IOException {
        String value = this.generateGet("super");
        AmberType type = this.getColumn().getType();
        this.getColumn().generateSetVersion(out, pstmt, index, value);
    }

    @Override
    public void generateUpdate(CharBuffer sql) {
        sql.append(this.getColumn().generateUpdateSet());
    }

    @Override
    public void generateUpdate(JavaWriter out, String maskVar, String pstmt, String index) throws IOException {
        this.generateSetVersion(out, pstmt, index);
    }
}

