/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.query.AmberSelectQuery;
import com.caucho.amber.query.FromItem;
import com.caucho.util.CurrentTime;
import java.lang.ref.SoftReference;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;

public class ResultSetCacheChunk {
    public static final int CACHE_CHUNK_SIZE = 64;
    private AmberSelectQuery _query;
    private ArrayList<FromItem> _fromList;
    private ArrayList<AmberExpr> _resultList;
    private int _startRow;
    private final ArrayList<Object[]> _results = new ArrayList();
    private SoftReference<ResultSetCacheChunk> _next;
    private boolean _isLast;
    private long _expireTime;

    public ResultSetCacheChunk() {
    }

    public ResultSetCacheChunk(ResultSetCacheChunk prev) {
        this._startRow = prev._startRow + 64;
        this._query = prev._query;
        this._fromList = prev._fromList;
        this._resultList = prev._resultList;
        this._expireTime = prev._expireTime;
    }

    public void setQuery(AmberSelectQuery query) {
        this._query = query;
        this._fromList = query.getFromList();
        this._resultList = query.getResultList();
        this._expireTime = CurrentTime.getCurrentTime() + query.getCacheMaxAge();
    }

    public AmberSelectQuery getQuery() {
        return this._query;
    }

    public long getExpireTime() {
        return this._expireTime;
    }

    public boolean isValid() {
        return CurrentTime.getCurrentTime() <= this._expireTime;
    }

    public void invalidate() {
        this._expireTime = 0L;
        this._next = null;
    }

    public boolean invalidate(String table, Object key) {
        if (this.getQuery().invalidateTable(table)) {
            this.invalidate();
            return true;
        }
        return false;
    }

    public int getRowCount() {
        return this._startRow + this._results.size();
    }

    public void newRow() {
        this._results.add(new Object[this._resultList.size()]);
    }

    public void setValue(int row, int column, Object value) {
        this._results.get((int)(row % 64))[column] = value;
    }

    public ResultSetCacheChunk getNext() {
        SoftReference<ResultSetCacheChunk> nextRef = this._next;
        if (nextRef != null) {
            return nextRef.get();
        }
        return null;
    }

    public void setNext(ResultSetCacheChunk next) {
        this._next = new SoftReference<ResultSetCacheChunk>(next);
    }

    public void setLast(boolean isLast) {
        this._isLast = isLast;
    }

    public boolean isLast() {
        return this._isLast;
    }

    public boolean isNull(int row, int column) {
        return this.getObject(row, column) == null;
    }

    public boolean getBoolean(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        if (object instanceof String) {
            String s = (String)object;
            return s.startsWith("t") || s.startsWith("y");
        }
        return object != null;
    }

    public byte getByte(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof String) {
            return Byte.parseByte((String)object);
        }
        if (object == null) {
            return 0;
        }
        return Byte.parseByte(String.valueOf(object));
    }

    public int getInt(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        if (object == null) {
            return 0;
        }
        return Integer.parseInt(String.valueOf(object));
    }

    public short getShort(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            return Short.parseShort((String)object);
        }
        if (object == null) {
            return 0;
        }
        return Short.parseShort(String.valueOf(object));
    }

    public long getLong(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        if (object instanceof Date) {
            return ((Date)object).getTime();
        }
        if (object == null) {
            return 0L;
        }
        return Long.parseLong(String.valueOf(object));
    }

    public double getDouble(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        if (object == null) {
            return 0.0;
        }
        return Double.parseDouble(String.valueOf(object));
    }

    public float getFloat(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof String) {
            return Float.parseFloat((String)object);
        }
        if (object == null) {
            return 0.0f;
        }
        return Float.parseFloat(String.valueOf(object));
    }

    public String getString(int row, int column) throws SQLException {
        Object object = this.getObject(row, column);
        if (object instanceof String) {
            return (String)object;
        }
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public final Object getObject(int row, int column) {
        return this._results.get(row % 64)[column];
    }
}

