/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IntegerType
extends AmberType {
    private static final L10N L = new L10N(IntegerType.class);
    private static final IntegerType INTEGER_TYPE = new IntegerType();

    private IntegerType() {
    }

    public static IntegerType create() {
        return INTEGER_TYPE;
    }

    @Override
    public String getName() {
        return "java.lang.Integer";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(4, length, precision, scale);
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.IntegerType.toInt(" + rs + ".getInt(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    @Override
    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.IntegerType.toInt(rs.getInt(columnNames[" + index + "]),rs.wasNull())");
        return index + 1;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.INTEGER);");
        out.println("else");
        out.println("  " + pstmt + ".setInt(" + index + "++, " + value + ".intValue());");
    }

    @Override
    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.INTEGER);");
    }

    @Override
    public void generateSetVersion(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setInt(" + index + "++, 1);");
        out.println("else");
        out.println("  " + pstmt + ".setInt(" + index + "++, " + value + ".intValue() + 1);");
    }

    @Override
    public String generateIncrementVersion(String value) throws IOException {
        return value + ".intValue() + 1";
    }

    @Override
    public Object toObject(long value) {
        return new Integer((int)value);
    }

    public static Integer toInt(int value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Integer(value);
    }

    @Override
    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 4);
        } else {
            pstmt.setInt(index, (Integer)value);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int index) throws SQLException {
        int value = rs.getInt(index);
        return rs.wasNull() ? null : new Integer(value);
    }
}

