/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.security.CodeSource;
import java.security.SecureClassLoader;

class ProLoader
extends SecureClassLoader {
    private Path _resinHome;
    private Path _libexec;
    private JarPath _resinJar;

    private ProLoader(Path resinHome, boolean is64bit) {
        super(ClassLoader.getSystemClassLoader());
        this._resinHome = resinHome;
        this._libexec = is64bit ? this._resinHome.lookup("libexec64") : this._resinHome.lookup("libexec");
        this._resinJar = JarPath.create(this._resinHome.lookup("lib/resin.jar"));
    }

    static ProLoader create(Path resinHome, boolean is64bit) {
        if (resinHome.lookup("lib/resin.jar").canRead()) {
            return new ProLoader(resinHome, is64bit);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String className = name.replace('.', '/') + ".class";
        Path path = this._resinJar.lookup(className);
        int length = (int)path.getLength();
        if (length > 0 && (className.startsWith("com/caucho/bootjni") || className.equals("com/caucho/vfs/JniFileStream.class") || className.equals("com/caucho/vfs/JniServerSocketImpl.class"))) {
            byte[] buffer = new byte[length];
            ReadStream is = null;
            try {
                Class<?> cl;
                is = path.openRead();
                is.readAll(buffer, 0, buffer.length);
                Class<?> clazz = cl = this.defineClass(name, buffer, 0, buffer.length, (CodeSource)null);
                is.close();
                return clazz;
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    @Override
    public String findLibrary(String name) {
        Path path = this._libexec.lookup("lib" + name + ".so");
        if (path.canRead()) {
            return path.getNativePath();
        }
        path = this._libexec.lookup("lib" + name + ".jnilib");
        if (path.canRead()) {
            return path.getNativePath();
        }
        return super.findLibrary(name);
    }
}

