/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.BootClusterConfig;
import com.caucho.boot.OpenPort;
import com.caucho.boot.WatchdogArgs;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.log.AbstractRolloverLog;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.util.ArrayList;

class WatchdogConfig {
    private static final int WATCHDOG_PORT_DEFAULT = 6600;
    private String _id;
    private final int _index;
    private final BootClusterConfig _cluster;
    private WatchdogArgs _args;
    private Path _rootDirectory;
    private Path _javaHome;
    private Path _javaExe;
    private String _jvmMode;
    private ArrayList<String> _jvmArgs = new ArrayList();
    private ArrayList<String> _jvmClasspath = new ArrayList();
    private ArrayList<String> _watchdogJvmArgs = new ArrayList();
    private Path _resinHome;
    private Path _resinRoot;
    private Path _resinConf;
    private String _systemClassLoader = "com.caucho.loader.SystemClassLoader";
    private boolean _is64bit;
    private boolean _hasXss;
    private boolean _hasXmx;
    private Path _chroot;
    private Path _pwd;
    private String _watchdogAddress = "127.0.0.1";
    private int _watchdogPort;
    private String _serverAddress = "127.0.0.1";
    private int _serverPort;
    private boolean _isRequireExplicitId;
    private WatchdogLog _watchdogLog;
    private Path _logPath;
    private String _userName;
    private String _groupName;
    private ArrayList<OpenPort> _ports = new ArrayList();
    private long _shutdownWaitTime = 60000L;
    private boolean _isVerbose;
    private boolean _hasWatchdogXss;
    private boolean _hasWatchdogXmx;
    private boolean _isElastic;
    private int _elasticServerPort;
    private String _elasticServerCluster;

    WatchdogConfig(String id, BootClusterConfig cluster, WatchdogArgs args, Path rootDirectory, int index) {
        if (id == null || "".equals(id)) {
            id = "default";
        }
        this._id = id;
        this._cluster = cluster;
        if (cluster != null) {
            this._elasticServerCluster = cluster.getId();
        }
        this._index = index;
        this._args = args;
        this._rootDirectory = rootDirectory;
        this._pwd = rootDirectory;
        this._is64bit = args.is64Bit();
    }

    public void setId(String id) {
        if (id == null || "".equals(id)) {
            id = "default";
        }
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public int getIndex() {
        return this._index;
    }

    String[] getArgv() {
        return this._args.getArgv();
    }

    public void setElastic(boolean isElastic) {
        this._isElastic = isElastic;
    }

    public boolean isElastic() {
        return this._isElastic;
    }

    public int getElasticServerPort() {
        return this._elasticServerPort;
    }

    public void setElasticServerPort(int port) {
        this._elasticServerPort = port;
    }

    public String getElasticServerCluster() {
        return this._elasticServerCluster;
    }

    public void setElasticServerCluster(String cluster) {
        this._elasticServerCluster = cluster;
    }

    public void setVerbose(boolean isVerbose) {
        this._isVerbose = isVerbose;
    }

    public void setJavaExe(Path javaExe) {
        this._javaExe = javaExe;
    }

    public void setJavaHome(Path javaHome) {
        this._javaHome = javaHome;
    }

    public Path getJavaHome() {
        if (this._javaHome != null) {
            return this._javaHome;
        }
        return this._args.getJavaHome();
    }

    @Configurable
    public void addJvmArg(String arg) {
        this._jvmArgs.add(arg);
        if (arg.equals("-d64")) {
            this._is64bit = true;
        } else if (arg.startsWith("-Xss")) {
            this._hasXss = true;
        } else if (arg.startsWith("-Xmx")) {
            this._hasXmx = true;
        }
    }

    @Configurable
    public void addJvmArgLine(String argLine) {
        for (String arg : argLine.split("\\s+")) {
            if ("".equals(arg)) continue;
            this.addJvmArg(arg);
        }
    }

    public ArrayList<String> getJvmArgs() {
        return this._jvmArgs;
    }

    @Configurable
    public void setJvmMode(String mode) {
        this._jvmMode = mode;
    }

    @Configurable
    public String getJvmMode() {
        return this._jvmMode;
    }

    public void addJvmClasspath(String item) {
        if (item == null) {
            return;
        }
        for (String cp : item.split("[" + File.pathSeparatorChar + "]")) {
            if (this._jvmClasspath.contains(cp)) continue;
            this._jvmClasspath.add(cp);
        }
    }

    public ArrayList<String> getJvmClasspath() {
        return this._jvmClasspath;
    }

    public BootClusterConfig getCluster() {
        return this._cluster;
    }

    public String getHomeCluster() {
        if (this._cluster != null) {
            return this._cluster.getResin().getHomeCluster();
        }
        return null;
    }

    public void addHttp(OpenPort port) throws ConfigException {
        port.setProtocolName("http");
        this._ports.add(port);
    }

    public OpenPort createProtocol() throws ConfigException {
        OpenPort port = new OpenPort();
        this._ports.add(port);
        return port;
    }

    public void addOpenPort(OpenPort port) {
        this._ports.add(port);
    }

    public void setUserName(String user) {
        if ("".equals(user)) {
            user = null;
        }
        this._userName = user;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setGroupName(String group) {
        if ("".equals(group)) {
            group = null;
        }
        this._groupName = group;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public Path getLogPath() {
        if (this._logPath != null) {
            return this._logPath;
        }
        String name = "".equals(this._id) ? "jvm-default.log" : "jvm-" + this._id.replace(':', '_') + ".log";
        return this.getLogDirectory().lookup(name);
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    public Path getLogDirectory() {
        Path logDirectory = this._args.getLogDirectory();
        if (logDirectory != null) {
            return logDirectory;
        }
        if (this._watchdogLog != null && this._watchdogLog.getLogDirectory() != null) {
            return this._watchdogLog.getLogDirectory();
        }
        return this.getRootDirectory().lookup("log");
    }

    void logInit(String name, AbstractRolloverLog log) {
        if (this._watchdogLog != null) {
            this._watchdogLog.logInit(name, log);
        }
    }

    public long getShutdownWaitTime() {
        return this._shutdownWaitTime;
    }

    public void setSystemClassLoader(String loader) {
        this._systemClassLoader = loader;
    }

    public String getSystemClassLoader() {
        return this._systemClassLoader;
    }

    public int getWatchdogPort() {
        if (this._args.getWatchdogPort() > 0) {
            return this._args.getWatchdogPort();
        }
        if (this._watchdogPort > 0) {
            return this._watchdogPort;
        }
        return 6600;
    }

    public void setWatchdogPort(int port) {
        this._watchdogPort = port;
    }

    public String getWatchdogAddress() {
        if (this._watchdogAddress != null) {
            return this._watchdogAddress;
        }
        return "127.0.0.1";
    }

    public void setWatchdogAddress(String addr) {
        this._watchdogAddress = addr;
    }

    public void addWatchdogArg(String arg) {
        this.addWatchdogJvmArg(arg);
    }

    public void addWatchdogJvmArg(String arg) {
        this._watchdogJvmArgs.add(arg);
        if (!arg.equals("-d64")) {
            if (arg.startsWith("-Xss")) {
                this._hasWatchdogXss = true;
            } else if (arg.startsWith("-Xmx")) {
                this._hasWatchdogXmx = true;
            }
        }
    }

    public ArrayList<String> getWatchdogJvmArgs() {
        return this._watchdogJvmArgs;
    }

    public WatchdogLog createWatchdogLog() {
        if (this._watchdogLog == null) {
            this._watchdogLog = new WatchdogLog();
        }
        return this._watchdogLog;
    }

    public void setAddress(String address) {
        this._serverAddress = address;
    }

    public String getAddress() {
        return this._serverAddress;
    }

    public void setPort(int port) {
        this._serverPort = port;
    }

    public int getPort() {
        return this._serverPort;
    }

    public void setRequireExplicitId(boolean isRequire) {
        this._isRequireExplicitId = isRequire;
    }

    public boolean isRequireExplicitId() {
        return this._isRequireExplicitId;
    }

    public void addContentProgram(ConfigProgram program) {
    }

    WatchdogArgs getArgs() {
        return this._args;
    }

    Iterable<OpenPort> getPorts() {
        return this._ports;
    }

    Path getChroot() {
        return this._chroot;
    }

    public void setChroot(Path chroot) {
        this._chroot = chroot;
    }

    Path getPwd() {
        return this._pwd;
    }

    Path getResinHome() {
        if (this._resinHome != null) {
            return this._resinHome;
        }
        return this._args.getResinHome();
    }

    public void setResinRoot(Path root) {
        this._resinRoot = root;
    }

    Path getResinRoot() {
        if (this._resinRoot != null) {
            return this._resinRoot;
        }
        return this._rootDirectory;
    }

    public void setResinConf(Path resinConf) {
        this._resinConf = resinConf;
    }

    public Path getResinConf() {
        if (this._resinConf != null) {
            return this._resinConf;
        }
        return this._args.getResinConf();
    }

    boolean hasWatchdogXmx() {
        return this._hasWatchdogXmx;
    }

    boolean hasWatchdogXss() {
        return this._hasWatchdogXss;
    }

    boolean hasXmx() {
        return this._hasXmx;
    }

    boolean hasXss() {
        return this._hasXss;
    }

    boolean is64bit() {
        return this._is64bit;
    }

    boolean isVerbose() {
        if (this._isVerbose) {
            return this._isVerbose;
        }
        return this._args.isVerbose();
    }

    String getJavaExe() {
        if (this._javaExe != null) {
            return this._javaExe.getNativePath();
        }
        Path javaHome = Vfs.lookup(System.getProperty("java.home"));
        if (javaHome.getTail().equals("jre")) {
            javaHome = javaHome.getParent();
        }
        if (javaHome.lookup("bin/javaw.exe").canRead()) {
            return javaHome.lookup("bin/javaw").getNativePath();
        }
        if (javaHome.lookup("bin/java.exe").canRead()) {
            return javaHome.lookup("bin/java").getNativePath();
        }
        if (javaHome.lookup("bin/java").canRead()) {
            return javaHome.lookup("bin/java").getNativePath();
        }
        javaHome = Vfs.lookup(System.getProperty("java.home"));
        if (javaHome.lookup("bin/javaw.exe").canRead()) {
            return javaHome.lookup("bin/javaw").getNativePath();
        }
        if (javaHome.lookup("bin/java.exe").canRead()) {
            return javaHome.lookup("bin/java").getNativePath();
        }
        if (javaHome.lookup("bin/java").canRead()) {
            return javaHome.lookup("bin/java").getNativePath();
        }
        return "java";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    public class WatchdogLog {
        private Path _logDirectory;
        private String _pathFormat;
        private String _archiveFormat;
        private Integer _rolloverCount;
        private Period _rolloverPeriod;
        private Bytes _rolloverSize;

        public void setLogDirectory(Path dir) {
            this._logDirectory = dir;
        }

        Path getLogDirectory() {
            return this._logDirectory;
        }

        public void setRolloverCount(int count) {
            this._rolloverCount = count;
        }

        public void setRolloverPeriod(Period period) {
            this._rolloverPeriod = period;
        }

        public void setRolloverSize(Bytes size) {
            this._rolloverSize = size;
        }

        public void setPathFormat(String format) {
            this._pathFormat = format;
        }

        public void setArchiveFormat(String format) {
            this._archiveFormat = format;
        }

        void logInit(String name, AbstractRolloverLog log) {
            if (this._pathFormat != null) {
                String pathFormat = this._pathFormat.replace("%{name}", name);
                log.setPathFormat(pathFormat);
            }
            if (this._archiveFormat != null) {
                String archiveFormat = this._archiveFormat.replace("%{name}", name);
                log.setArchiveFormat(archiveFormat);
            }
            if (this._rolloverCount != null) {
                log.setRolloverCount(this._rolloverCount);
            }
            if (this._rolloverPeriod != null) {
                log.setRolloverPeriod(this._rolloverPeriod);
            }
            if (this._rolloverSize != null) {
                log.setRolloverSize(this._rolloverSize);
            }
            System.out.println("LI0: " + log);
        }
    }
}

