/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.network;

import com.caucho.bam.mailbox.DualSizeMailbox;
import com.caucho.cloud.network.ClusterServer;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ClusterServerMXBean;
import com.caucho.network.balance.ClientSocketFactory;
import java.util.Date;

public class ClusterServerAdmin
extends AbstractManagedObject
implements ClusterServerMXBean {
    private final ClusterServer _server;

    public ClusterServerAdmin(ClusterServer server) {
        this._server = server;
    }

    @Override
    public String getName() {
        return this._server.getId();
    }

    @Override
    public String getType() {
        return "ClusterServer";
    }

    @Override
    public ClusterMXBean getCluster() {
        return this._server.getCluster().getAdmin();
    }

    @Override
    public int getClusterIndex() {
        return this._server.getIndex();
    }

    @Override
    public String getAddress() {
        return this._server.getAddress();
    }

    @Override
    public int getPort() {
        return this._server.getPort();
    }

    @Override
    public boolean isDynamicServer() {
        return this._server.isDynamic();
    }

    @Override
    public boolean isTriadServer() {
        return this._server.isTriad();
    }

    @Override
    public boolean isSelfServer() {
        return this._server.isSelf();
    }

    @Override
    public long getRecoverTime() {
        return this._server.getLoadBalanceRecoverTime();
    }

    @Override
    public long getIdleTime() {
        return this._server.getLoadBalanceIdleTime();
    }

    @Override
    public int getConnectionMin() {
        return this._server.getLoadBalanceConnectionMin();
    }

    @Override
    public long getConnectTimeout() {
        return this._server.getLoadBalanceConnectTimeout();
    }

    @Override
    public long getSocketTimeout() {
        return this._server.getLoadBalanceSocketTimeout();
    }

    @Override
    public long getClusterIdleTime() {
        return this._server.getClusterIdleTime();
    }

    @Override
    public long getWarmupTime() {
        return this._server.getLoadBalanceWarmupTime();
    }

    @Override
    public int getWeight() {
        return this._server.getLoadBalanceWeight();
    }

    @Override
    public String getClusterState() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getState();
        }
        return "self";
    }

    @Override
    public String getLoadBalanceState() {
        ClientSocketFactory pool = this._server.getLoadBalanceSocketPool();
        if (pool != null) {
            return pool.getState();
        }
        return "self";
    }

    @Override
    public boolean isHeartbeatActive() {
        return this._server.isHeartbeatActive();
    }

    @Override
    public String getHeartbeatState() {
        return this._server.getHeartbeatState();
    }

    @Override
    public Date getLastHeartbeatTime() {
        long lastHeartbeatTime = this._server.getLastHeartbeatTime();
        if (lastHeartbeatTime > 0L) {
            return new Date(lastHeartbeatTime);
        }
        return null;
    }

    @Override
    public int getConnectionActiveCount() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getActiveCount();
        }
        return 0;
    }

    @Override
    public int getConnectionIdleCount() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getIdleCount();
        }
        return 0;
    }

    @Override
    public long getConnectionNewCountTotal() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getConnectCountTotal();
        }
        return 0L;
    }

    @Override
    public long getConnectionFailCountTotal() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getFailCountTotal();
        }
        return 0L;
    }

    @Override
    public Date getLastFailTime() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getLastFailTime();
        }
        return null;
    }

    public Date getLastSuccessTime() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return new Date(pool.getLastSuccessTime());
        }
        return null;
    }

    @Override
    public double getLatencyFactor() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getLatencyFactor();
        }
        return 0.0;
    }

    @Override
    public long getConnectionBusyCountTotal() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getBusyCountTotal();
        }
        return 0L;
    }

    @Override
    public Date getLastBusyTime() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getLastBusyTime();
        }
        return null;
    }

    @Override
    public long getConnectionKeepaliveCountTotal() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getKeepaliveCountTotal();
        }
        return 0L;
    }

    @Override
    public double getServerCpuLoadAvg() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.getCpuLoadAvg();
        }
        return 0.0;
    }

    @Override
    public int getMessageQueueSize() {
        DualSizeMailbox mbox = this._server.getCloudServer().getData(DualSizeMailbox.class);
        if (mbox != null) {
            return mbox.getSmallQueueSize();
        }
        return -1;
    }

    @Override
    public int getMessageQueueLargeSize() {
        DualSizeMailbox mbox = this._server.getCloudServer().getData(DualSizeMailbox.class);
        if (mbox != null) {
            return mbox.getLargeQueueSize();
        }
        return -1;
    }

    @Override
    public void start() {
        this._server.getCloudServer().enable();
        ClientSocketFactory pool = this._server.getLoadBalanceSocketPool();
        if (pool != null) {
            pool.start();
        }
    }

    @Override
    public void stop() {
        this._server.getCloudServer().disable();
        ClientSocketFactory pool = this._server.getLoadBalanceSocketPool();
        if (pool != null) {
            pool.stop();
        }
    }

    @Override
    public void enableSessionOnly() {
        this._server.getCloudServer().disableSoft();
        ClientSocketFactory pool = this._server.getLoadBalanceSocketPool();
        if (pool != null) {
            pool.enableSessionOnly();
        }
    }

    @Override
    public boolean ping() {
        ClientSocketFactory pool = this._server.getClusterSocketPool();
        if (pool != null) {
            return pool.canConnect();
        }
        return true;
    }

    @Override
    public void removeDynamicServer() {
    }

    protected void register() {
        this.registerSelf();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getObjectName() + "]";
    }
}

