/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.attribute;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.util.L10N;
import com.caucho.xml.QName;

public abstract class Attribute {
    private static final L10N L = new L10N(Attribute.class);

    public abstract ConfigType<?> getConfigType();

    public boolean isBean() {
        return this.getConfigType().isBean();
    }

    public boolean isEL() {
        return this.getConfigType().isEL();
    }

    public boolean isNode() {
        return this.getConfigType().isNode();
    }

    public boolean isProgram() {
        return this.getConfigType().isProgram();
    }

    public boolean isAllowInline() {
        return false;
    }

    public boolean isInlineType(ConfigType<?> type) {
        return false;
    }

    public boolean isAllowText() {
        return true;
    }

    public boolean isConfigurable() {
        return false;
    }

    public boolean isAssignableFrom(Attribute oldAttr) {
        return false;
    }

    public boolean isAssignableFrom(ConfigType<?> type) {
        return true;
    }

    public void setText(Object bean, QName name, String value) throws ConfigException {
        Object childBean;
        if (value.trim().equals("") && (childBean = this.create(bean, name)) != null) {
            ConfigType<?> type = TypeFactory.getType(childBean.getClass());
            type.init(childBean);
            Object newBean = this.replaceObject(childBean);
            this.setValue(bean, name, newBean);
            return;
        }
        throw new ConfigException(L.l("{0}: '{1}' does not allow text for attribute {2}.", (Object)this, (Object)this.getConfigType().getTypeName(), (Object)name));
    }

    public abstract void setValue(Object var1, QName var2, Object var3) throws ConfigException;

    public boolean isSetter() {
        return true;
    }

    public Object create(Object parent, QName name, ConfigType<?> type) throws ConfigException {
        return this.create(parent, name);
    }

    public Object create(Object parent, QName name) throws ConfigException {
        return null;
    }

    public ConfigType<?> getType(Object childBean) {
        return this.getConfigType().getType(childBean);
    }

    public Object replaceObject(Object bean) {
        return this.getConfigType().replaceObject(bean);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getConfigType() + "]";
    }
}

