/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.bytecode.ScopeProxy;
import com.caucho.config.inject.AbstractIntrospectedBean;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.DisposesProducer;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ProducesCreationalContext;
import com.caucho.config.program.Arg;
import com.caucho.config.reflect.BaseType;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;

@Module
public class ProducesFieldBean<X, T>
extends AbstractIntrospectedBean<T> {
    private static final L10N L = new L10N(ProducesFieldBean.class);
    private final Bean<X> _producerBean;
    private final AnnotatedField<X> _beanField;
    private FieldProducer _fieldProducer;
    private DisposesProducer _disposesProducer;
    private Producer<T> _producer;
    private boolean _isBound;
    private boolean _isPassivating;
    private boolean _isStatic;

    protected ProducesFieldBean(InjectManager manager, Bean<X> producerBean, AnnotatedField<X> beanField, AnnotatedMethod<X> disposesMethod, Arg[] disposesArgs) {
        super(manager, beanField.getBaseType(), (Annotated)beanField);
        this._producer = this._fieldProducer = new FieldProducer();
        this._producerBean = producerBean;
        this._beanField = beanField;
        this._isStatic = beanField.isStatic();
        if (disposesMethod != null) {
            this._disposesProducer = new DisposesProducer(manager, producerBean, disposesMethod, disposesArgs);
        }
        if (beanField == null) {
            throw new NullPointerException();
        }
    }

    public static ProducesFieldBean create(InjectManager manager, Bean producer, AnnotatedField beanField, AnnotatedMethod disposesMethod, Arg[] disposesArgs) {
        ProducesFieldBean bean = new ProducesFieldBean(manager, producer, beanField, disposesMethod, disposesArgs);
        bean.introspect();
        bean.introspect((Annotated)beanField);
        BaseType type = manager.createSourceBaseType(beanField.getBaseType());
        if (type.isGeneric()) {
            throw new InjectionException(L.l("'{0}' is an invalid @Produces field because it returns a generic type {1}", (Object)beanField.getJavaMember(), (Object)type));
        }
        return bean;
    }

    public Producer<T> getProducer() {
        return this._producer;
    }

    public void setProducer(Producer<T> producer) {
        this._producer = producer;
    }

    public Bean<X> getProducerBean() {
        return this._producerBean;
    }

    @Override
    public Class<?> getBeanClass() {
        return this._producerBean.getBeanClass();
    }

    public AnnotatedField<X> getField() {
        return this._beanField;
    }

    @Override
    protected String getDefaultName() {
        return this._beanField.getJavaMember().getName();
    }

    @Override
    public void introspect() {
        super.introspect();
        this._isPassivating = this.getBeanManager().isPassivatingScope(this.getScope());
    }

    @Override
    public T create(CreationalContext<T> createEnv) {
        Object value = this._producer.produce(createEnv);
        return (T)value;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> cxt) {
        if (this._producer == this._fieldProducer) {
            this._fieldProducer.destroy(instance, (CreationalContextImpl)cxt);
        } else {
            this._producer.dispose(instance);
        }
        if (cxt instanceof CreationalContextImpl) {
            CreationalContextImpl env = (CreationalContextImpl)cxt;
            env.clearTarget();
        }
        cxt.release();
    }

    @Override
    public void bind() {
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        Field field = this._beanField.getJavaMember();
        sb.append(this.getTargetSimpleName());
        sb.append(", ");
        sb.append(field.getDeclaringClass().getSimpleName());
        sb.append(".");
        sb.append(field.getName());
        sb.append("()");
        sb.append(", {");
        boolean isFirst = true;
        for (Annotation ann : this.getQualifiers()) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(ann);
            isFirst = false;
        }
        sb.append("}");
        if (this.getName() != null) {
            sb.append(", name=");
            sb.append(this.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    class FieldProducer
    implements Producer<T> {
        FieldProducer() {
        }

        public T produce(CreationalContext<T> cxt) {
            Object factory;
            ProducesCreationalContext producerCxt;
            Class type = ProducesFieldBean.this._producerBean.getBeanClass();
            if (cxt instanceof CreationalContextImpl) {
                CreationalContextImpl parentCxt = (CreationalContextImpl)cxt;
                producerCxt = new ProducesCreationalContext(ProducesFieldBean.this._producerBean, parentCxt);
            } else {
                producerCxt = new ProducesCreationalContext(ProducesFieldBean.this._producerBean, null);
            }
            if (ProducesFieldBean.this._isStatic) {
                factory = null;
            } else {
                factory = ProducesFieldBean.this.getBeanManager().getReference(ProducesFieldBean.this._producerBean, type, producerCxt);
                if (factory == null) {
                    throw new IllegalStateException(L.l("{0}: unexpected null factory for {1}", (Object)this, (Object)ProducesFieldBean.this._producerBean));
                }
            }
            if (factory instanceof ScopeProxy) {
                ScopeProxy proxy = (ScopeProxy)factory;
                factory = proxy.__caucho_getDelegate();
            }
            CreationalContextImpl env = (CreationalContextImpl)cxt;
            Object instance = this.produce(factory, env.findInjectionPoint());
            if (ProducesFieldBean.this._producerBean.getScope() == Dependent.class) {
                ProducesFieldBean.this._producerBean.destroy(factory, producerCxt);
            }
            if (ProducesFieldBean.this._isPassivating && !(instance instanceof Serializable)) {
                throw new IllegalProductException(L.l("'{0}' is an invalid @{1} instance because it's not serializable for bean {2}", instance, (Object)ProducesFieldBean.this.getScope().getSimpleName(), (Object)this));
            }
            return instance;
        }

        private T produce(X bean, InjectionPoint ij) {
            try {
                Field field = ProducesFieldBean.this._beanField.getJavaMember();
                field.setAccessible(true);
                Object value = ProducesFieldBean.this._beanField.getJavaMember().get(bean);
                if (value != null) {
                    return value;
                }
                if (!Dependent.class.equals(ProducesFieldBean.this.getScope())) {
                    throw new IllegalProductException(L.l("'{0}' is an invalid producer because it returns null", bean));
                }
                return value;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void destroy(T instance, CreationalContextImpl<T> cxt) {
            if (ProducesFieldBean.this._disposesProducer != null) {
                ProducesFieldBean.this._disposesProducer.destroy(instance, cxt);
            }
        }

        public void dispose(T instance) {
            if (ProducesFieldBean.this._disposesProducer != null) {
                ProducesFieldBean.this._disposesProducer.dispose(instance);
            }
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return ProducesFieldBean.this.getInjectionPoints();
        }

        public String toString() {
            Field javaField = ProducesFieldBean.this._beanField.getJavaMember();
            return this.getClass().getSimpleName() + "[" + javaField.getDeclaringClass().getSimpleName() + "." + javaField.getName() + "]";
        }
    }
}

