/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.xml;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.xml.XmlBeanConfig;
import com.caucho.config.xml.XmlConfigContext;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import javax.enterprise.context.spi.CreationalContext;

public class XmlBeanAddAttribute<T>
extends Attribute {
    private static final L10N L = new L10N(XmlBeanAddAttribute.class);
    private final ConfigType<T> _configType;

    public XmlBeanAddAttribute(Class<T> cl) {
        this._configType = TypeFactory.getType(cl);
    }

    public ConfigType<T> getConfigType() {
        return this._configType;
    }

    @Override
    public boolean isProgram() {
        return true;
    }

    @Override
    public Object create(Object parent, QName qName) throws ConfigException {
        return this._configType.create(parent, qName);
    }

    @Override
    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        try {
            XmlBeanConfig customBean = (XmlBeanConfig)bean;
            customBean.addAdd((ConfigProgram)value);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public void setText(Object bean, QName name, String text) throws ConfigException {
        try {
            XmlBeanConfig customBean = (XmlBeanConfig)bean;
            customBean.addAdd(new TextAddProgram(text));
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    static class TextAddProgram
    extends ConfigProgram {
        private String _arg;

        TextAddProgram(String arg) {
            this._arg = arg;
        }

        @Override
        public <T> void inject(T bean, CreationalContext<T> env) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }

        public Object configure(ConfigType type, XmlConfigContext env) throws ConfigException {
            return type.valueOf(this._arg);
        }
    }
}

