/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.blob;

import com.caucho.db.blob.Inode;
import com.caucho.db.block.BlockStore;
import com.caucho.db.xa.RawTransaction;
import com.caucho.db.xa.StoreTransaction;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.Writer;

class ClobWriter
extends Writer {
    private BlockStore _store;
    private StoreTransaction _xa;
    private TempBuffer _tempBuffer;
    private byte[] _buffer;
    private int _offset;
    private int _bufferEnd;
    private long _length;
    private Inode _inode;
    private byte[] _inodeBuffer;
    private int _inodeOffset;

    ClobWriter(StoreTransaction xa, BlockStore store, byte[] inode, int inodeOffset) {
        this.init(xa, store, inode, inodeOffset);
    }

    ClobWriter(Inode inode) {
        this.init(null, inode.getStore(), inode.getBuffer(), 0);
        this._inode = inode;
    }

    public void init(StoreTransaction xa, BlockStore store, byte[] inode, int inodeOffset) {
        if (xa == null) {
            xa = RawTransaction.create();
        }
        this._xa = xa;
        this._store = store;
        this._length = 0L;
        this._inodeBuffer = inode;
        this._inodeOffset = inodeOffset;
        Inode.clear(this._inodeBuffer, this._inodeOffset);
        this._offset = 0;
        this._tempBuffer = TempBuffer.allocate();
        this._buffer = this._tempBuffer.getBuffer();
        this._bufferEnd = this._buffer.length;
    }

    @Override
    public void write(int v) throws IOException {
        if (this._bufferEnd <= this._offset) {
            this.flushBlock();
        }
        this._buffer[this._offset++] = (byte)(v >> 8);
        this._buffer[this._offset++] = (byte)v;
        this._length += 2L;
    }

    @Override
    public void write(char[] buffer, int offset, int length) throws IOException {
        byte[] byteBuffer = this._buffer;
        int byteOffset = this._offset;
        while (length > 0) {
            int sublen;
            if (this._bufferEnd <= byteOffset) {
                this._offset = byteOffset;
                this.flushBlock();
                byteOffset = this._offset;
            }
            if (length < (sublen = this._bufferEnd - byteOffset >> 1)) {
                sublen = length;
            }
            for (int i = 0; i < sublen; ++i) {
                char ch = buffer[offset + i];
                byteBuffer[byteOffset++] = (byte)(ch >> 8);
                byteBuffer[byteOffset++] = (byte)ch;
            }
            offset += sublen;
            length -= sublen;
            this._length += (long)(2 * sublen);
        }
        this._offset = byteOffset;
    }

    private void flushBlock() throws IOException {
        int length = this._offset;
        this._offset = 0;
        Inode.append(this._inodeBuffer, this._inodeOffset, this._store, this._xa, this._buffer, 0, length);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        try {
            this.flushBlock();
            TempBuffer.free(this._tempBuffer);
            this._tempBuffer = null;
        }
        finally {
            if (this._inode != null) {
                this._inode.closeOutputStream();
            }
        }
    }
}

