/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.jdbc.GenericMetaData;
import com.caucho.util.Log;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class PostgresMetaData
extends GenericMetaData {
    private static final Logger log = Log.open(PostgresMetaData.class);

    protected PostgresMetaData(DataSource ds) {
        super(ds);
    }

    @Override
    public String getFalseLiteral() {
        return "false";
    }

    @Override
    public boolean supportsPositionFunction() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsUpdateTableAlias() {
        return false;
    }

    @Override
    public String createSequenceSQL(String name, int size) {
        if (size > 1) {
            return "CREATE SEQUENCE " + name + " INCREMENT " + size;
        }
        return "CREATE SEQUENCE " + name;
    }

    @Override
    public String selectSequenceSQL(String name) {
        return "SELECT Nextval('" + name + "')";
    }

    @Override
    public String testSequenceSQL(String name) {
        return "SELECT Currval('" + name + "')";
    }

    @Override
    public String generateBoolean(String term) {
        return "(" + term + " = 't')";
    }
}

