/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.jdbc.GenericMetaData;
import com.caucho.util.Log;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class SqlServerMetaData
extends GenericMetaData {
    private static final Logger log = Log.open(SqlServerMetaData.class);

    protected SqlServerMetaData(DataSource ds) {
        super(ds);
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public String createIdentitySQL(String sqlType) {
        return " uniqueidentifier NOT NULL DEFAULT(NEWID())";
    }

    @Override
    public String getCreateColumnSQL(int sqlType, int length, int precision, int scale) {
        String type = null;
        switch (sqlType) {
            case 16: {
                type = this.getCreateColumnSQLImpl(-7, length, precision, scale);
                break;
            }
            case -6: {
                type = this.getCreateColumnSQLImpl(-6, length, precision, scale);
                break;
            }
            case 91: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
                if (type != null) break;
                type = this.getCreateColumnSQLImpl(93, length, precision, scale);
                break;
            }
            case 92: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
                if (type != null) break;
                type = this.getCreateColumnSQLImpl(93, length, precision, scale);
                break;
            }
            case 8: {
                type = this.getCreateColumnSQLImpl(6, length, precision, scale);
                break;
            }
            case 2: {
                type = this.getCreateColumnSQLImpl(2, length, precision, scale);
                break;
            }
            default: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
            }
        }
        if (type == null) {
            type = this.getDefaultCreateTableSQL(sqlType, length, precision, scale);
        }
        return type;
    }

    @Override
    public String generateBoolean(String term) {
        return term + "= 1";
    }
}

