/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.HandleAware;
import com.caucho.jms.connection.ConnectionImpl;
import com.caucho.jms.connection.QueueConnectionImpl;
import com.caucho.jms.connection.TopicConnectionImpl;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.sql.DataSource;

public class ConnectionFactoryImpl
implements XAQueueConnectionFactory,
XATopicConnectionFactory,
Serializable,
HandleAware {
    private static final Logger log = Logger.getLogger(ConnectionFactoryImpl.class.getName());
    private static final L10N L = new L10N(ConnectionFactoryImpl.class);
    private String _name;
    private String _clientID;
    private String _user;
    private String _password;
    private List<ConnectionImpl> _connections = Collections.synchronizedList(new ArrayList());
    private HashMap<String, Queue> _queues = new HashMap();
    private HashMap<String, Topic> _topics = new HashMap();
    private Object _serializationHandle;

    public void setUser(String user) {
        this._user = user;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setClientID(String id) {
        this._clientID = id;
    }

    public void setDataSource(DataSource dataSource) {
    }

    @Override
    public void setSerializationHandle(Object handle) {
        this._serializationHandle = handle;
    }

    public void init() throws ConfigException, SQLException {
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(this._user, this._password);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        this.authenticate(username, password);
        ConnectionImpl conn = new ConnectionImpl(this);
        if (this._clientID != null) {
            if (this.findByClientID(this._clientID) != null) {
                throw new JMSException(L.l("ClientID[{0}] is only allowed for a single connection.", (Object)this._clientID));
            }
            conn.setClientID(this._clientID);
        }
        this.addConnection(conn);
        return conn;
    }

    protected void addConnection(ConnectionImpl conn) {
        this._connections.add(conn);
    }

    public ConnectionImpl findByClientID(String id) {
        for (int i = 0; i < this._connections.size(); ++i) {
            ConnectionImpl conn = this._connections.get(i);
            try {
                if (!id.equals(conn.getClientID())) continue;
                return conn;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public void removeConnection(ConnectionImpl conn) {
        this._connections.remove(conn);
    }

    public Queue createQueue(String name) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Topic createTopic(String name) throws JMSException {
        throw new UnsupportedOperationException();
    }

    protected void authenticate(String username, String password) throws JMSException {
        if (this._user != null && !this._user.equals(username) || this._password != null && !this._password.equals(password)) {
            throw new JMSSecurityException(L.l("'{0}' is an unknown user", (Object)username));
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        this.authenticate(username, password);
        QueueConnectionImpl conn = new QueueConnectionImpl(this);
        this.addConnection(conn);
        return conn;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        this.authenticate(username, password);
        TopicConnectionImpl conn = new TopicConnectionImpl(this, true);
        this.addConnection(conn);
        return conn;
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(null, null);
    }

    public XAConnection createXAConnection(String username, String password) throws JMSException {
        this.authenticate(username, password);
        ConnectionImpl conn = new ConnectionImpl(this, true);
        if (this._clientID != null) {
            if (this.findByClientID(this._clientID) != null) {
                throw new JMSException(L.l("ClientID[{0}] is only allowed for a single connection.", (Object)this._clientID));
            }
            conn.setClientID(this._clientID);
        }
        this.addConnection(conn);
        return conn;
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createXAQueueConnection(null, null);
    }

    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        this.authenticate(username, password);
        QueueConnectionImpl conn = new QueueConnectionImpl(this, true);
        this.addConnection(conn);
        return conn;
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return this.createXATopicConnection(null, null);
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        this.authenticate(username, password);
        TopicConnectionImpl conn = new TopicConnectionImpl(this, true);
        this.addConnection(conn);
        return conn;
    }

    private Object writeReplace() {
        return this._serializationHandle;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

