/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jca;

import com.caucho.jms.jca.ListenerEndpoint;
import com.caucho.jms.jca.MessageListenerTask;
import com.caucho.jms.jca.ResourceAdapterImpl;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;

public class MessageListenerSpec
implements ActivationSpec {
    private static final L10N L = new L10N(MessageListenerSpec.class);
    private static final Logger log = Logger.getLogger(MessageListenerSpec.class.getName());
    private ResourceAdapterImpl _ra;
    private MessageEndpointFactory _factory;
    private ArrayList<MessageListenerTask> _endpoints = new ArrayList();

    public ResourceAdapter getResourceAdapter() {
        return this._ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (!(ra instanceof ResourceAdapterImpl)) {
            throw new ResourceException(L.l("'{0}' is not a valid resource adapter for the JMS MessageListenerSpec", (Object)ra.getClass().getName()));
        }
        this._ra = (ResourceAdapterImpl)ra;
    }

    void setEndpointFactory(MessageEndpointFactory factory) {
        this._factory = factory;
    }

    public void validate() throws InvalidPropertyException {
    }

    void start() throws ResourceException {
        try {
            ListenerEndpoint endpoint = (ListenerEndpoint)this._factory.createEndpoint(null);
            MessageListenerTask task = new MessageListenerTask(this._ra, endpoint);
            this._endpoints.add(task);
            this._ra.getWorkManager().startWork((Work)task);
        }
        catch (JMSException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    void stop() throws JMSException {
        for (int i = 0; i < this._endpoints.size(); ++i) {
            MessageListenerTask task = this._endpoints.get(i);
            try {
                task.release();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        this._endpoints.clear();
    }
}

