/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.config.inject.InjectManager;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspUtil;
import com.caucho.jsp.TagInstance;
import com.caucho.jsp.java.JspAttribute;
import com.caucho.jsp.java.JspContainerNode;
import com.caucho.jsp.java.JspExpression;
import com.caucho.jsp.java.JspFragmentNode;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.jsp.java.JspRoot;
import com.caucho.jsp.java.JspScriptlet;
import com.caucho.jsp.java.JspTagFileSupport;
import com.caucho.jsp.java.JspTop;
import com.caucho.jsp.java.StaticText;
import com.caucho.util.BeanUtil;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.servlet.jsp.tagext.VariableInfo;

public abstract class GenericTag
extends JspContainerNode {
    private static final Logger log = Logger.getLogger(GenericTag.class.getName());
    private static final String DEFAULT_VAR_TYPE = "java.lang.String";
    private static final HashSet<String> _primTypes = new HashSet();
    protected TagInstance _tag;
    protected TagInfo _tagInfo;
    protected Class<?> _tagClass;
    protected VariableInfo[] _varInfo;
    private boolean _isDeclaringInstance;

    public void setTagInfo(TagInfo tagInfo) {
        this._tagInfo = tagInfo;
    }

    public TagInfo getTagInfo() {
        return this._tagInfo;
    }

    @Override
    public boolean isJsp21() {
        return !this.isPre21Taglib();
    }

    @Override
    public boolean isPre21Taglib() {
        if (this._tagInfo == null) {
            return false;
        }
        TagLibraryInfo library = this._tagInfo.getTagLibrary();
        if (library == null || library.getRequiredVersion() == null) {
            return false;
        }
        return "2.1".compareTo(library.getRequiredVersion()) > 0;
    }

    @Override
    public TagInstance getTag() {
        return this._tag;
    }

    @Override
    public String getCustomTagName() {
        return this._tag.getId();
    }

    public boolean isSimple() {
        return this._tag.isSimpleTag();
    }

    @Override
    public boolean isJstl() {
        String uri = this._tag.getTagInfo().getTagLibrary().getURI();
        return "http://java.sun.com/jsp/jstl/core".equals(uri) || "http://java.sun.com/jstl/core".equals(uri) || "http://java.sun.com/jsp/jstl/fmt".equals(uri) || "http://java.sun.com/jsp/jstl/xml".equals(uri) || "http://java.sun.com/jstl/xml".equals(uri) || "http://java.sun.com/jsp/jstl/sql".equals(uri) || "http://java.sun.com/jstl/sql".equals(uri);
    }

    public void setTagClass(Class cl) {
        this._tagClass = cl;
    }

    public VariableInfo[] getVarInfo() {
        return this._varInfo;
    }

    @Override
    public String getBodyContent() {
        return this._tagInfo.getBodyContent();
    }

    @Override
    public void addChild(JspNode node) throws JspParseException {
        if (!"empty".equals(this.getBodyContent())) {
            super.addChild(node);
        } else if (node instanceof JspAttribute) {
            super.addChild(node);
        } else if (!(node instanceof StaticText) || !((StaticText)node).isWhitespace()) {
            throw this.error(L.l("<{0}> must be empty.  Since <{0}> has a body-content of 'empty', it must not have any content.", (Object)this.getTagName()));
        }
    }

    @Override
    public void endElement() throws Exception {
        TagExtraInfo tei;
        this.addTagDepend();
        Hashtable<String, Object> tags = new Hashtable<String, Object>();
        for (int i = 0; i < this._attributeNames.size(); ++i) {
            QName qName = (QName)this._attributeNames.get(i);
            Object value = this._attributeValues.get(i);
            String name = qName.getName();
            TagAttributeInfo attrInfo = this.getAttributeInfo(qName);
            Method method = this.getAttributeMethod(qName);
            Class<JspFragment> type = null;
            if (method != null) {
                type = method.getParameterTypes()[0];
            }
            if (value instanceof JspAttribute) {
                JspAttribute attr = (JspAttribute)value;
                if (attr.isStatic()) {
                    String textValue = attr.getStaticText();
                    tags.put(name, textValue);
                } else {
                    tags.put(name, TagData.REQUEST_TIME_VALUE);
                }
            } else if (value instanceof String && this.hasRuntimeAttribute((String)value)) {
                tags.put(name, TagData.REQUEST_TIME_VALUE);
            } else {
                tags.put(name, value);
            }
            String typeName = null;
            boolean isFragment = false;
            if (attrInfo != null) {
                typeName = attrInfo.getTypeName();
                isFragment = attrInfo.isFragment();
                if (isFragment && type != null && type.isAssignableFrom(JspFragment.class)) {
                    typeName = JspFragment.class.getName();
                }
            } else if (method != null) {
                typeName = type.getName();
            }
            if (!isFragment && !JspFragment.class.getName().equals(typeName) || !(value instanceof JspAttribute)) continue;
            JspAttribute jspAttr = (JspAttribute)value;
            jspAttr.setJspFragment(true);
        }
        TagData tagData = new TagData(tags);
        try {
            this._varInfo = this._tagInfo.getVariableInfo(tagData);
        }
        catch (Exception e) {
            throw this.error(e);
        }
        if (this._varInfo == null) {
            this._varInfo = this.fillVariableInfo(this._tagInfo.getTagVariableInfos(), tagData);
        }
        if ((tei = this._tagInfo.getTagExtraInfo()) != null) {
            ValidationMessage[] messages = tei.validate(tagData);
            this._gen.addDepend(tei.getClass());
            if (messages != null && messages.length != 0) {
                throw this.error(messages[0].getMessage());
            }
        }
    }

    protected void addTagDepend() {
        if (this._tagClass != null) {
            this._gen.addDepend(this._tagClass);
        }
    }

    @Override
    public boolean hasScripting() {
        if (super.hasScripting()) {
            return true;
        }
        for (int i = 0; i < this._attributeValues.size(); ++i) {
            QName name = (QName)this._attributeNames.get(i);
            Object value = this._attributeValues.get(i);
            try {
                if (!(value instanceof String) || !this.hasRuntimeAttribute((String)value)) continue;
                return true;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isJsfParentRequired() {
        return true;
    }

    public boolean isDeclaringInstance() {
        return this._isDeclaringInstance;
    }

    @Override
    public String getJsfVar() {
        return null;
    }

    @Override
    public String getJsfBodyVar() {
        return null;
    }

    @Override
    public void generateClassEpilogue(JspJavaWriter out) throws IOException {
        super.generateClassEpilogue(out);
        if (this._tag.getAnalyzedTag().getHasInjection() && !this._tag.getAndSetInjectFactory(true)) {
            out.println();
            out.print("static ");
            out.printClass(InjectManager.ReferenceFactory.class);
            out.println(" _jsp_inject_" + this._tag.getId());
            out.print("  = ");
            out.printClass(JspUtil.class);
            out.print(".getInjectFactory(");
            out.printClass(this._tag.getTagClass());
            out.println(".class);");
        }
    }

    @Override
    public void generatePrologue(JspJavaWriter out) throws Exception {
        for (int i = 0; i < this._attributeNames.size(); ++i) {
            Method method;
            QName name = (QName)this._attributeNames.get(i);
            Object value = this._attributeValues.get(i);
            if (!(value instanceof JspFragmentNode)) continue;
            JspFragmentNode frag = (JspFragmentNode)value;
            TagAttributeInfo attribute = this.getAttributeInfo(name);
            String typeName = null;
            boolean isFragment = false;
            if (attribute != null && attribute.isFragment()) {
                isFragment = true;
            }
            String fragmentClass = JspFragment.class.getName();
            if (attribute != null && fragmentClass.equals(attribute.getTypeName())) {
                isFragment = true;
            }
            if ((method = this.getAttributeMethod(name)) != null && fragmentClass.equals(typeName = method.getParameterTypes()[0].getName())) {
                isFragment = true;
            }
            if (!isFragment) continue;
            frag.generateFragmentPrologue(out);
        }
        TagInstance parent = this.getParent().getTag();
        boolean isBodyTag = BodyTag.class.isAssignableFrom(this._tagClass);
        boolean isEmpty = this.isEmpty();
        boolean hasBodyContent = isBodyTag && !isEmpty;
        this._tag = parent.findTag(this.getQName(), this._attributeNames, hasBodyContent);
        if (this._tag == null || !this._parseState.isRecycleTags()) {
            this._tag = parent.addTag(this._gen, this.getQName(), this._tagInfo, this._tagClass, this._attributeNames, this._attributeValues, hasBodyContent);
            if (!JspTagFileSupport.class.isAssignableFrom(this._tagClass)) {
                out.printClass(this._tagClass);
                out.println(" " + this._tag.getId() + " = null;");
            }
            this._isDeclaringInstance = true;
        } else {
            for (int i = 0; i < this._attributeNames.size(); ++i) {
                QName name = (QName)this._attributeNames.get(i);
                Object value = this._attributeValues.get(i);
                this._tag.addAttribute(name, value);
            }
        }
        if (this._tag == null) {
            throw new NullPointerException();
        }
        this.generatePrologueDeclare(out);
        this.generatePrologueChildren(out);
    }

    @Override
    public void generatePrologueDeclare(JspJavaWriter out) throws Exception {
        for (int i = 0; this._varInfo != null && i < this._varInfo.length; ++i) {
            VariableInfo var = this._varInfo[i];
            if (var == null || !this._gen.hasScripting() || var.getScope() != 2 && var.getScope() != 1 || !var.getDeclare() || this._gen.isDeclared(var.getVarName())) continue;
            String className = var.getClassName();
            if (className == null || "".equals(className) || "null".equals(className)) {
                className = DEFAULT_VAR_TYPE;
            }
            this.validateClass(className, var.getVarName());
            out.print(className + " " + var.getVarName() + " = ");
            this._gen.addDeclared(var.getVarName());
            if ("byte".equals(var.getClassName()) || "short".equals(var.getClassName()) || "char".equals(var.getClassName()) || "int".equals(var.getClassName()) || "long".equals(var.getClassName()) || "float".equals(var.getClassName()) || "double".equals(var.getClassName())) {
                out.println("0;");
                continue;
            }
            if ("boolean".equals(var.getClassName())) {
                out.println("false;");
                continue;
            }
            out.println("null;");
        }
    }

    @Override
    public void printXml(WriteStream os) throws IOException {
        TagInfo tag = this.getTagInfo();
        String prefix = tag.getTagLibrary().getPrefixString();
        String uri = tag.getTagLibrary().getURI();
        String name = prefix + ':' + tag.getTagName();
        os.print("<" + name);
        os.print(" xmlns:" + prefix + "=\"" + uri + "\"");
        this.printJspId(os);
        for (int i = 0; i < this._attributeNames.size(); ++i) {
            QName attrName = (QName)this._attributeNames.get(i);
            Object value = this._attributeValues.get(i);
            if (!(value instanceof String)) continue;
            String string = (String)value;
            this.printXmlAttribute(os, attrName.getName(), string);
        }
        os.print(">");
        this.printXmlChildren(os);
        os.print("</" + name + ">");
    }

    @Override
    public abstract void generate(JspJavaWriter var1) throws Exception;

    protected void fillAttributes(JspJavaWriter out, String name) throws Exception {
        TagAttributeInfo[] attrs = this._tagInfo.getAttributes();
        for (int i = 0; attrs != null && i < attrs.length; ++i) {
            int p = this.getAttributeIndex(attrs[i].getName());
            if (p >= 0 || !attrs[i].isRequired()) continue;
            throw this.error(L.l("required attribute '{0}' missing from <{1}>", (Object)attrs[i].getName(), (Object)this.getTagName()));
        }
        boolean isDynamic = DynamicAttributes.class.isAssignableFrom(this._tagClass);
        for (int i = 0; i < this._attributeNames.size(); ++i) {
            QName attrName = (QName)this._attributeNames.get(i);
            Object value = this._attributeValues.get(i);
            TagAttributeInfo attribute = this.getAttributeInfo(attrName);
            if (attrs != null && attribute == null && !isDynamic) {
                throw this.error(L.l("unexpected attribute '{0}' in <{1}>", (Object)attrName.getName(), (Object)this.getTagName()));
            }
            if (this._tag.getAttribute(attrName) != null) continue;
            boolean isFragment = false;
            if (attribute != null) {
                boolean bl = isFragment = attribute.isFragment() || JspFragment.class.getName().equals(attribute.getTypeName());
            }
            if (value instanceof JspAttribute && ((JspAttribute)value).isJspFragment()) {
                isFragment = true;
            }
            this.generateSetAttribute(out, name, attrName, value, attribute == null || attribute.canBeRequestTime(), isFragment, attribute);
        }
    }

    private TagAttributeInfo getAttributeInfo(QName attrName) {
        TagAttributeInfo[] attrs = this._tagInfo.getAttributes();
        int j = 0;
        for (j = 0; attrs != null && j < attrs.length; ++j) {
            if (!this.isNameMatch(attrs[j].getName(), attrName)) continue;
            return attrs[j];
        }
        return null;
    }

    private int getAttributeIndex(String name) {
        for (int i = 0; i < this._attributeNames.size(); ++i) {
            QName attrName = (QName)this._attributeNames.get(i);
            if (!this.isNameMatch(name, attrName)) continue;
            return i;
        }
        return -1;
    }

    private boolean isNameMatch(String defName, QName attrName) {
        if (defName.equals(attrName.getName())) {
            return true;
        }
        return defName.equals(attrName.getLocalName()) && attrName.getPrefix().equals(this.getQName().getPrefix());
    }

    void generateSetAttribute(JspJavaWriter out, String name, QName attrName, Object value, boolean allowRtexpr, boolean isFragment, TagAttributeInfo attrInfo) throws Exception {
        Method method = this.getAttributeMethod(attrName);
        boolean isDynamic = DynamicAttributes.class.isAssignableFrom(this._tagClass);
        if (method != null) {
            if (Modifier.isStatic(method.getModifiers())) {
                throw this.error(L.l("attribute '{0}' may not be a static method.", (Object)method.getName()));
            }
            this.generateSetParameter(out, name, value, method, allowRtexpr, "pageContext", false, isFragment, attrInfo);
        } else {
            if (!isDynamic) {
                throw this.error(L.l("attribute '{0}' in tag '{1}' has no corresponding set method in tag class '{2}'", (Object)attrName.getName(), (Object)this.getTagName(), (Object)this._tagClass.getName()));
            }
            if (isFragment) {
                String uri = attrName.getNamespaceURI();
                String local = attrName.getLocalName();
                out.print(name + ".setDynamicAttribute(");
                if (uri == null) {
                    out.print("null, ");
                } else {
                    out.print("\"" + GenericTag.escapeJavaString(uri) + "\", ");
                }
                JspFragmentNode frag = (JspFragmentNode)value;
                out.print("\"" + GenericTag.escapeJavaString(local) + "\", ");
                out.print(frag.generateValue());
                out.println(");");
            } else {
                String uri = attrName.getNamespaceURI();
                String local = attrName.getLocalName();
                out.print(name + ".setDynamicAttribute(");
                if (uri == null) {
                    out.print("null, ");
                } else {
                    out.print("\"" + GenericTag.escapeJavaString(uri) + "\", ");
                }
                out.print("\"" + GenericTag.escapeJavaString(local) + "\", ");
                out.print(this.generateRTValue(Object.class, value));
                out.println(");");
            }
        }
    }

    private Method getAttributeMethod(QName attrName) throws Exception {
        Method method = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(this._tagClass);
            if (info != null) {
                method = BeanUtil.getSetMethod(info, attrName.getLocalName());
            }
            if (method != null) {
                return method;
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return method;
    }

    protected boolean hasVarDeclaration(int scope) throws Exception {
        for (int i = 0; this._varInfo != null && i < this._varInfo.length; ++i) {
            VariableInfo var = this._varInfo[i];
            if (var == null || var.getScope() != scope) continue;
            return true;
        }
        return false;
    }

    protected void printVarDeclaration(JspJavaWriter out, int scope) throws Exception {
        for (int i = 0; this._varInfo != null && i < this._varInfo.length; ++i) {
            VariableInfo var = this._varInfo[i];
            if (var == null) continue;
            this.printVarDeclare(out, scope, var);
            this.printVarAssign(out, scope, var);
        }
    }

    protected void printVarDeclare(JspJavaWriter out, int scope) throws Exception {
        for (int i = 0; this._varInfo != null && i < this._varInfo.length; ++i) {
            VariableInfo var = this._varInfo[i];
            if (var == null) continue;
            this.printVarDeclare(out, scope, var);
        }
    }

    protected void printVarAssign(JspJavaWriter out, int scope) throws Exception {
        for (int i = 0; this._varInfo != null && i < this._varInfo.length; ++i) {
            VariableInfo var = this._varInfo[i];
            if (var == null) continue;
            this.printVarAssign(out, scope, var);
        }
    }

    protected VariableInfo[] fillVariableInfo(TagVariableInfo[] tagVars, TagData tagData) throws JspParseException {
        if (tagVars == null) {
            return null;
        }
        VariableInfo[] vars = new VariableInfo[tagVars.length];
        for (int i = 0; i < tagVars.length; ++i) {
            TagVariableInfo tagVar = tagVars[i];
            String name = null;
            String attributeName = tagVar.getNameFromAttribute();
            if (attributeName != null) {
                Object value = tagData.getAttribute(attributeName);
                if (value != null && !(value instanceof String)) {
                    throw this.error(L.l("tag variable '{0}' may not be a request time attribute", (Object)attributeName));
                }
                name = tagData.getAttributeString(attributeName);
            }
            if (name == null || "".equals(name) || "null".equals(name)) {
                name = null;
            }
            if (tagVar.getNameGiven() != null) {
                if (name != null) {
                    throw this.error(L.l("name-given='{0}' conflicts with name-from-attribute='{1}' because the attribute value is the same as name-given.", (Object)tagVar.getNameGiven(), (Object)attributeName));
                }
                name = tagVar.getNameGiven();
            } else if (name == null) continue;
            vars[i] = new VariableInfo(name, tagVar.getClassName(), tagVar.getDeclare(), tagVar.getScope());
        }
        return vars;
    }

    protected void printVarDeclare(JspJavaWriter out, int scope, VariableInfo var) throws Exception {
        if (!this._gen.hasScripting() || var == null || var.getVarName() == null || "".equals(var.getVarName()) || "null".equals(var.getVarName())) {
            return;
        }
        if (var.getScope() == scope || var.getScope() == 1) {
            if (var.getVarName() == null) {
                throw this.error(L.l("tag variable expects a name"));
            }
            String className = var.getClassName();
            if (className == null || "".equals(className) || "null".equals(className)) {
                className = DEFAULT_VAR_TYPE;
            }
            this.validateVarName(var.getVarName());
            if (var.getDeclare() && var.getScope() == scope && (var.getScope() == 0 && this.hasScripting() || var.getScope() == 1) && !this.varAlreadyDeclared(var.getVarName())) {
                this.validateClass(className, var.getVarName());
                out.println(className + " " + var.getVarName() + ";");
            }
        }
    }

    protected void printVarAssign(JspJavaWriter out, int scope, VariableInfo var) throws Exception {
        if ("".equals(var.getVarName()) || "null".equals(var.getVarName())) {
            return;
        }
        if (var.getScope() == scope || var.getScope() == 1) {
            if (var.getVarName() == null) {
                throw this.error(L.l("tag variable expects a name"));
            }
            String className = var.getClassName();
            if (className == null || className.equals("null")) {
                className = DEFAULT_VAR_TYPE;
            }
            this.validateVarName(var.getVarName());
            if (this._gen.hasScripting() && (var.getScope() != 0 || this.hasScripting())) {
                out.setLocation(this._filename, this._startLine);
                out.print(var.getVarName() + " = ");
                String v = "pageContext.findAttribute(\"" + var.getVarName() + "\")";
                this.convertParameterValue(out, className, v);
                out.println(";");
            }
            try {
                this._gen.addBeanClass(var.getVarName(), className);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                throw this.error(L.l("'{0}' is an unknown class for tag variable '{1}' in <{2}>", (Object)className, (Object)var.getVarName(), (Object)this.getTagInfo().getTagName()), cause);
            }
        }
    }

    private void validateVarName(String name) throws JspParseException {
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            throw this.error(L.l("tag variable '{0}' is an illegal Java identifier.", (Object)name));
        }
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            throw this.error(L.l("tag variable '{0}' is an illegal Java identifier.", (Object)name));
        }
    }

    private boolean varAlreadyDeclared(String varName) {
        if (this._gen.isDeclared(varName)) {
            return true;
        }
        for (JspNode node = this.getParent(); node != null; node = node.getParent()) {
            if (!(node instanceof GenericTag)) continue;
            if (node instanceof JspFragmentNode) break;
            GenericTag tag = (GenericTag)node;
            VariableInfo[] varInfo = tag.getVarInfo();
            for (int i = 0; varInfo != null && i < varInfo.length; ++i) {
                if (varInfo[i] == null || !varInfo[i].getVarName().equals(varName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isReuse() {
        return this._gen.getRecycleTags();
    }

    protected boolean isDeclared() {
        if (!this._gen.getRecycleTags()) {
            return false;
        }
        JspNode parent = this.getParent();
        if (!(parent instanceof JspRoot || parent instanceof JspTop || parent instanceof GenericTag || parent instanceof JspAttribute)) {
            return false;
        }
        boolean isDeclared = false;
        ArrayList<JspNode> siblings = this.getParent().getChildren();
        for (int i = 0; i < siblings.size(); ++i) {
            GenericTag customTag;
            JspNode node = siblings.get(i);
            if (node == this) {
                return isDeclared;
            }
            if (this.hasScriptlet(node)) {
                return false;
            }
            if (!(node instanceof GenericTag) || (customTag = (GenericTag)node).getTag() != this.getTag()) continue;
            isDeclared = true;
        }
        return isDeclared;
    }

    protected boolean hasScriptlet(JspNode node) {
        if (node instanceof JspScriptlet || node instanceof JspExpression) {
            return true;
        }
        ArrayList<JspNode> children = node.getChildren();
        if (children == null) {
            return false;
        }
        for (int i = 0; i < children.size(); ++i) {
            JspNode child = children.get(i);
            if (!this.hasScriptlet(child)) continue;
            return true;
        }
        return false;
    }

    protected void validateClass(String className, String varName) throws JspParseException {
        try {
            if (_primTypes.contains(className)) {
                return;
            }
            if (className.endsWith("[]")) {
                this.validateClass(className.substring(0, className.length() - 2), varName);
                return;
            }
            Class<?> clazz = this._gen.getBeanClass(className);
        }
        catch (ClassNotFoundException e) {
            throw this.error(L.l("'{0}' is an unknown class for tag variable '{1}'.", (Object)className, (Object)varName));
        }
    }

    static {
        _primTypes.add("boolean");
        _primTypes.add("byte");
        _primTypes.add("short");
        _primTypes.add("int");
        _primTypes.add("long");
        _primTypes.add("float");
        _primTypes.add("double");
        _primTypes.add("char");
    }
}

