/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.util.QDate;
import java.io.Serializable;

public class HealthEventLog
implements Serializable,
Comparable<HealthEventLog> {
    private HealthEventLogType _type;
    private long _timestamp;
    private String _source;
    private String _message;

    public HealthEventLog() {
    }

    public HealthEventLog(HealthEventLogType type) {
        this._type = type;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public HealthEventLogType getType() {
        return this._type;
    }

    public String getTypeName() {
        return this._type.getName();
    }

    public String getTypeDescription() {
        return this._type.getDescription();
    }

    public void setType(HealthEventLogType type) {
        this._type = type;
    }

    public String getSource() {
        return this._source;
    }

    public void setSource(String source) {
        this._source = source;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public String toString() {
        return String.format("%s[%s, %s, %s, %s]", new Object[]{this.getClass().getSimpleName(), this._type, QDate.formatISO8601(this._timestamp), this._source, this._message});
    }

    @Override
    public int compareTo(HealthEventLog o) {
        long anotherVal;
        long thisVal = this.getTimestamp();
        if (thisVal == (anotherVal = o.getTimestamp())) {
            return this.getType().compareTo(o.getType());
        }
        return thisVal < anotherVal ? 1 : -1;
    }

    public static enum HealthEventLogType {
        START_MESSAGE("Resin|Startup", "Startup Message"),
        START_TIME("Resin|StartTime", "Server Startup"),
        CHECK("Resin|Health|Check", "Health Alarm"),
        RECHECK("Resin|Health|Recheck", "Recheck"),
        RECOVER("Resin|Health|Recover", "Health Recovery"),
        ACTION("Resin|Health|Action", "Health Action"),
        ANOMALY("Resin|Health|Anomaly", "Anomaly Detected");

        private final String _name;
        private final String _description;

        private HealthEventLogType(String name, String description) {
            this._name = name;
            this._description = description;
        }

        public String getName() {
            return this._name;
        }

        public String getDescription() {
            return this._description;
        }

        public static HealthEventLogType fromTypeName(String name) {
            for (HealthEventLogType type : HealthEventLogType.values()) {
                if (!name.endsWith(type.getName())) continue;
                return type;
            }
            return null;
        }
    }
}

