/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.memcached;

import com.caucho.cache.Cache;
import com.caucho.cache.CacheException;
import com.caucho.cache.CacheMXBean;
import com.caucho.cache.CacheManager;
import com.caucho.cache.CacheStatistics;
import com.caucho.cache.Configuration;
import com.caucho.cache.Status;
import com.caucho.cache.event.CacheEntryEventFilter;
import com.caucho.cache.event.CacheEntryListener;
import com.caucho.cloud.loadbalance.LoadBalanceBuilder;
import com.caucho.cloud.loadbalance.LoadBalanceManager;
import com.caucho.cloud.loadbalance.LoadBalanceService;
import com.caucho.cloud.loadbalance.StickyRequestHashGenerator;
import com.caucho.config.Configurable;
import com.caucho.config.types.Period;
import com.caucho.distcache.LocalCache;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.memcached.MemcachedCacheEngine;
import com.caucho.network.balance.ClientSocket;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.CacheImpl;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.server.distcache.DistCacheSystem;
import com.caucho.server.distcache.MnodeUpdate;
import com.caucho.util.CharBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.util.HashKey;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class MemcachedClient
implements Cache {
    private static final L10N L = new L10N(MemcachedClient.class);
    private static final Logger log = Logger.getLogger(MemcachedClient.class.getName());
    private LoadBalanceBuilder _loadBalanceBuilder;
    private LoadBalanceManager _loadBalancer;
    private String _name = "default";
    private CharBuffer _cb = new CharBuffer();
    private Hessian2Input _hIn = new Hessian2Input();
    private Boolean _isResin;
    private long _modifiedExpireTimeout = 3600000L;
    private AtomicReference<CacheImpl> _localCache = new AtomicReference();
    private MemcachedCacheEngine _cacheEngine;

    public MemcachedClient() {
        LoadBalanceService loadBalanceService;
        DistCacheSystem cacheSystem = DistCacheSystem.getCurrent();
        if (cacheSystem != null) {
            this._cacheEngine = new MemcachedCacheEngine(cacheSystem.getDistCacheManager(), this);
        }
        if ((loadBalanceService = LoadBalanceService.getCurrent()) == null) {
            throw new IllegalStateException(L.l("'{0}' requires an active {1}", (Object)this, (Object)LoadBalanceService.class.getSimpleName()));
        }
        this._loadBalanceBuilder = loadBalanceService.createBuilder();
        this._loadBalanceBuilder.setStickyRequestHashGenerator(new StickyGenerator());
        this._loadBalanceBuilder.setMeterCategory("Resin|WebSocket");
        this._loadBalanceBuilder.setIdleTime(120000L);
    }

    public MemcachedClient(String name) {
        this();
        this._name = name;
    }

    public void addServer(String address, int port) {
        this._loadBalanceBuilder.addAddress(address + ":" + port);
    }

    public void addAddress(String address) {
        this._loadBalanceBuilder.addAddress(address);
    }

    public void setCluster(String cluster) {
        this._loadBalanceBuilder.setTargetCluster(cluster);
    }

    public void setPort(int port) {
        this._loadBalanceBuilder.setTargetPort(port);
    }

    @Configurable
    public void setModifiedExpireTimeout(Period timeout) {
        this._modifiedExpireTimeout = timeout.getPeriod();
    }

    public boolean containsKey(Object key) throws CacheException {
        return this.get(key) != null;
    }

    public Object get(Object key) throws CacheException {
        boolean isResin;
        if (this._isResin == null) {
            this.initResin();
        }
        boolean bl = isResin = this._isResin != null && this._isResin != false;
        if (!isResin) {
            return this.getImpl(String.valueOf(key));
        }
        CacheImpl cache = this.getLocalCache();
        Object value = cache.get(key);
        if (value != null) {
            return value;
        }
        value = this.getImpl(String.valueOf(key));
        cache.put(key, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getImpl(String key) throws CacheException {
        ClientSocket client = this._loadBalancer.openSticky(null, key, null);
        if (client == null) {
            throw new CacheException("Cannot open client");
        }
        boolean isValid = false;
        long idleStartTime = CurrentTime.getCurrentTime();
        try {
            WriteStream out = client.getOutputStream();
            ReadStream is = client.getInputStream();
            out.print("get ");
            out.print(key);
            out.print("\r\n");
            out.flush();
            this.readString(is, this._cb);
            if (this._cb.matches("END")) {
                if (this.skipToEndOfLine(is)) {
                    isValid = true;
                }
                Object var8_8 = null;
                return var8_8;
            }
            if (!this._cb.matches("VALUE")) {
                System.out.println("Expected value: " + this._cb);
                Object var8_9 = null;
                return var8_9;
            }
            this.readString(is, this._cb);
            long flags = this.readInt(is);
            long length = this.readInt(is);
            long hash = this.readInt(is);
            if (!this.skipToEndOfLine(is)) {
                System.out.println("EOLF:");
                Object var14_13 = null;
                return var14_13;
            }
            GetInputStream gis = new GetInputStream(is, length);
            Hessian2Input hIn = this._hIn;
            hIn.init((InputStream)gis);
            Object value = hIn.readObject();
            this.skipToEndOfLine(is);
            this.readString(is, this._cb);
            if (!this._cb.matches("END")) {
                Object var17_17 = null;
                return var17_17;
            }
            if (!this.skipToEndOfLine(is)) {
                Object var17_18 = null;
                return var17_18;
            }
            isValid = true;
            Object object = value;
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (isValid) {
                client.free(idleStartTime);
            } else {
                client.close();
            }
        }
        return null;
    }

    MnodeUpdate getResinIfModified(String key, long oldValue, DistCacheEntry entry) throws CacheException {
        try {
            return this.resinGetIfModifiedImpl(key, oldValue, entry);
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
            try {
                return this.resinGetIfModifiedImpl(key, oldValue, entry);
            }
            catch (IOException e2) {
                log.log(Level.FINER, e2.toString(), e2);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MnodeUpdate resinGetIfModifiedImpl(String key, long oldValueHash, DistCacheEntry entry) throws IOException {
        long now;
        CacheImpl cache = this.getLocalCache();
        long version = entry.getMnodeEntry().getVersion();
        version = version < (now = CurrentTime.getCurrentTime()) ? now : ++version;
        ClientSocket client = this._loadBalancer.openSticky(null, key, null);
        if (client == null) {
            throw new CacheException("Cannot open client");
        }
        boolean isValid = false;
        long idleStartTime = CurrentTime.getCurrentTime();
        try {
            WriteStream out = client.getOutputStream();
            ReadStream is = client.getInputStream();
            out.print("get_if_modified ");
            out.print(key);
            out.print(" ");
            out.print(oldValueHash);
            out.print("\r\n");
            out.flush();
            if (!this.readString(is, this._cb)) {
                throw new IOException("unexpected end of file");
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " get_if_modified " + key + "\n  " + client + "\n  " + this._cb);
            }
            if (this._cb.matches("END")) {
                MnodeUpdate update;
                this.skipToEndOfLine(is);
                isValid = true;
                CacheConfig config = entry.getConfig();
                MnodeUpdate mnodeUpdate = update = new MnodeUpdate(0L, 0L, version, config);
                return mnodeUpdate;
            }
            if (this._cb.matches("NOT_MODIFIED")) {
                if (this.skipToEndOfLine(is) && this.readString(is, this._cb) && this._cb.matches("END") && this.skipToEndOfLine(is)) {
                    isValid = true;
                }
                MnodeUpdate config = null;
                return config;
            }
            if (!this._cb.matches("VALUE")) {
                System.out.println("VALUE: " + this._cb);
                MnodeUpdate config = null;
                return config;
            }
            this.readString(is, this._cb);
            long flags = this.readInt(is);
            long length = this.readInt(is);
            long serverHash = this.readInt(is);
            if (!this.skipToEndOfLine(is)) {
                System.out.println("EOLF:");
                MnodeUpdate mnodeUpdate = null;
                return mnodeUpdate;
            }
            GetInputStream gis = new GetInputStream(is, length);
            MnodeUpdate update = null;
            this.skipToEndOfLine(is);
            this.readString(is, this._cb);
            if (!this._cb.matches("END")) {
                MnodeUpdate mnodeUpdate = null;
                return mnodeUpdate;
            }
            if (!this.skipToEndOfLine(is)) {
                MnodeUpdate mnodeUpdate = null;
                return mnodeUpdate;
            }
            isValid = true;
            MnodeUpdate mnodeUpdate = update;
            return mnodeUpdate;
        }
        finally {
            if (isValid) {
                client.free(idleStartTime);
            } else {
                client.close();
            }
        }
    }

    public void put(Object key, Object value) throws CacheException {
        boolean isResin;
        if (this._isResin == null) {
            this.initResin();
        }
        boolean bl = isResin = this._isResin != null && this._isResin != false;
        if (isResin) {
            CacheImpl cache = this.getLocalCache();
            cache.put(key, value);
        }
        this.putImpl(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putImpl(Object key, Object value) throws CacheException {
        ClientSocket client = null;
        long idleStartTime = CurrentTime.getCurrentTime();
        boolean isValid = false;
        try {
            client = this._loadBalancer.openSticky(null, key, null);
            if (client == null) {
                throw new CacheException("Cannot put memcache");
            }
            WriteStream out = client.getOutputStream();
            ReadStream is = client.getInputStream();
            TempStream ts = this.serialize(value);
            long length = ts.getLength();
            out.print("set ");
            out.print(key);
            long flags = 0L;
            out.print(" ");
            out.print(flags);
            out.print(" ");
            long expTime = this._modifiedExpireTimeout;
            out.print(expTime);
            out.print(" ");
            out.print(length);
            out.print("\r\n");
            ts.writeToStream(out);
            out.print("\r\n");
            out.flush();
            String line = is.readLine();
            if (!"STORED".equals(line)) {
                System.out.println("BAD: " + line);
                throw new IllegalStateException("Expected 'STORED' at " + line);
            }
            isValid = true;
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (client != null) {
                if (isValid) {
                    client.free(idleStartTime);
                } else {
                    client.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putResin(String key, MnodeUpdate update, long valueDataId) throws CacheException {
        ClientSocket client = null;
        long idleStartTime = CurrentTime.getCurrentTime();
        long valueDataTime = 0L;
        CacheImpl cache = this.getLocalCache();
        boolean isValid = false;
        try {
            String line;
            client = this._loadBalancer.openSticky(null, key, null);
            if (client == null) {
                throw new CacheException("Cannot put memcache");
            }
            WriteStream out = client.getOutputStream();
            ReadStream is = client.getInputStream();
            long length = update.getValueLength();
            out.print("set ");
            out.print(key);
            long flags = update.getUserFlags();
            out.print(" ");
            out.print(flags);
            out.print(" ");
            long expTime = update.getModifiedExpireTimeout();
            out.print(expTime / 1000L);
            out.print(" ");
            out.print(length);
            out.print("\r\n");
            out.setDisableClose(true);
            boolean v = cache.loadData(valueDataId, valueDataTime, out);
            out.setDisableClose(false);
            out.print("\r\n");
            out.flush();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " resin_set " + key + " " + Long.toHexString(update.getValueHash()) + "\n  " + client + "\n  " + this._cb);
            }
            if (!"STORED".equals(line = is.readLine())) {
                System.out.println("BAD: " + line);
                throw new IllegalStateException("Expected 'STORED' at " + line);
            }
            isValid = true;
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (client != null) {
                if (isValid) {
                    client.free(idleStartTime);
                } else {
                    client.close();
                }
            }
        }
    }

    public boolean remove(Object key) throws CacheException {
        boolean isResin;
        if (this._isResin == null) {
            this.initResin();
        }
        boolean bl = isResin = this._isResin != null && this._isResin != false;
        if (isResin) {
            CacheImpl cache = this.getLocalCache();
            cache.remove(key);
        } else {
            this.removeImpl(key);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeImpl(Object key) throws CacheException {
        ClientSocket client = null;
        long idleStartTime = CurrentTime.getCurrentTime();
        boolean isValid = false;
        try {
            client = this._loadBalancer.openSticky(null, key, null);
            if (client == null) {
                throw new CacheException("Cannot put memcache");
            }
            WriteStream out = client.getOutputStream();
            ReadStream is = client.getInputStream();
            out.print("delete ");
            out.print(key);
            long timeout = 0L;
            out.print(" ");
            out.print(timeout);
            out.print("\r\n");
            out.flush();
            String line = is.readLine();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " delete " + key + "\n  " + client + "\n  " + line);
            }
            if (line.equals("DELETED")) {
                isValid = true;
            } else if (line.equals("NOT_FOUND")) {
                isValid = true;
            } else {
                System.out.println("UKNOWNK :" + line);
            }
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (client != null) {
                if (isValid) {
                    client.free(idleStartTime);
                } else {
                    client.close();
                }
            }
        }
    }

    private static long getCasKey(HashKey valueKey) {
        if (valueKey == null) {
            return 0L;
        }
        byte[] valueHash = valueKey.getHash();
        return ((long)valueHash[0] & 0x7FL) << 56 | ((long)valueHash[1] & 0xFFL) << 48 | ((long)valueHash[2] & 0xFFL) << 40 | ((long)valueHash[3] & 0xFFL) << 32 | ((long)valueHash[4] & 0xFFL) << 24 | ((long)valueHash[5] & 0xFFL) << 16 | ((long)valueHash[6] & 0xFFL) << 8 | (long)valueHash[7] & 0xFFL;
    }

    private CacheImpl getLocalCache() {
        CacheImpl cache = this._localCache.get();
        if (cache == null) {
            LocalCache localCache = new LocalCache();
            localCache.setName("memcache:" + this._name);
            localCache.setModifiedExpireTimeoutMillis(this._modifiedExpireTimeout);
            localCache.setLocalExpireTimeoutMillis(1000L);
            localCache.setEngine(this._cacheEngine);
            cache = localCache.createIfAbsent();
            this._localCache.compareAndSet(null, cache);
        }
        return this._localCache.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        if (this._loadBalancer != null) {
            return;
        }
        MemcachedClient memcachedClient = this;
        synchronized (memcachedClient) {
            if (this._loadBalancer == null) {
                this._loadBalancer = this._loadBalanceBuilder.create();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initResin() {
        if (this._isResin != null) {
            return;
        }
        this.init();
        DistCacheSystem cacheSystem = DistCacheSystem.getCurrent();
        if (cacheSystem == null) {
            this._isResin = false;
            return;
        }
        ClientSocket client = this._loadBalancer.open();
        if (client == null) {
            return;
        }
        long idleStartTime = CurrentTime.getCurrentTime();
        boolean isValid = false;
        try {
            String line;
            WriteStream out = client.getOutputStream();
            ReadStream is = client.getInputStream();
            out.print("stats resin\r\n");
            out.flush();
            while ((line = is.readLine()) != null && !(line = line.trim()).equals("END") && line.indexOf("ERROR") < 0) {
                if (!line.equals("STAT enable_get_if_modified 1")) continue;
                this._isResin = true;
            }
            isValid = true;
            if (this._isResin == null) {
                this._isResin = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (isValid) {
                client.free(idleStartTime);
            } else {
                client.close();
            }
        }
    }

    private long readInt(ReadStream is) throws IOException {
        int ch;
        long value = 0L;
        while ((ch = is.read()) >= 0 && ch == 32) {
        }
        while (48 <= ch && ch <= 57) {
            value = 10L * value + (long)ch - 48L;
            ch = is.read();
        }
        is.unread();
        return value;
    }

    private boolean readString(ReadStream is, CharBuffer cb) throws IOException {
        this._cb.clear();
        int ch = is.read();
        while (ch >= 0 && ch == 32) {
            ch = is.read();
        }
        if (ch < 0) {
            return false;
        }
        while (ch >= 0 && !Character.isWhitespace(ch)) {
            cb.append((char)ch);
            ch = is.read();
        }
        if (ch >= 0) {
            is.unread();
        }
        return true;
    }

    private boolean skipToEndOfLine(ReadStream is) throws IOException {
        int ch;
        while ((ch = is.read()) >= 0 && ch != 13) {
        }
        return ch == 13 && (ch = is.read()) == 10;
    }

    public Object getAndPut(Object key, Object value) throws CacheException {
        return null;
    }

    public Object getAndRemove(Object key) throws CacheException {
        return null;
    }

    public Object getAndReplace(Object key, Object value) throws CacheException {
        return null;
    }

    public CacheStatistics getStatistics() {
        return null;
    }

    public Configuration getConfiguration() {
        return null;
    }

    public String getName() {
        return null;
    }

    public Future load(Object key) throws CacheException {
        return null;
    }

    public Future loadAll(Set keys) throws CacheException {
        return null;
    }

    private TempStream serialize(Object value) throws IOException {
        TempStream ts = new TempStream();
        WriteStream out = new WriteStream(ts);
        Hessian2Output hOut = new Hessian2Output((OutputStream)out);
        hOut.writeObject(value);
        hOut.close();
        out.close();
        return ts;
    }

    public void putAll(Map map) throws CacheException {
    }

    public boolean putIfAbsent(Object key, Object value) throws CacheException {
        return false;
    }

    public boolean remove(Object key, Object oldValue) throws CacheException {
        return false;
    }

    public void removeAll() throws CacheException {
    }

    public boolean replace(Object key, Object oldValue, Object newValue) throws CacheException {
        return false;
    }

    public boolean replace(Object key, Object value) throws CacheException {
        return false;
    }

    public boolean unregisterCacheEntryListener(CacheEntryListener listener) {
        return false;
    }

    public Iterator iterator() {
        return null;
    }

    public Status getStatus() {
        return null;
    }

    public void start() throws CacheException {
    }

    public CacheMXBean getMBean() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void stop() throws CacheException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    public Object unwrap(Class cl) {
        return null;
    }

    public Map getAll(Set keys) {
        return null;
    }

    public Object invokeEntryProcessor(Object key, Cache.EntryProcessor entryProcessor) {
        return null;
    }

    public void removeAll(Set keys) {
    }

    public CacheManager getCacheManager() {
        return null;
    }

    public boolean registerCacheEntryListener(CacheEntryListener listener, boolean requireOldValue, CacheEntryEventFilter filter, boolean synchronous) {
        return false;
    }

    static class StickyGenerator
    implements StickyRequestHashGenerator {
        StickyGenerator() {
        }

        @Override
        public String getHash(Object requestInfo) {
            return (String)requestInfo;
        }
    }

    static class GetInputStream
    extends InputStream {
        private ReadStream _is;
        private long _length;

        GetInputStream(ReadStream is, long length) {
            this._is = is;
            this._length = length;
        }

        @Override
        public int read() throws IOException {
            if (this._length <= 0L) {
                return -1;
            }
            int ch = this._is.read();
            --this._length;
            return ch;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int sublen = (int)this._length;
            if (sublen <= 0) {
                return -1;
            }
            if (length < sublen) {
                sublen = length;
            }
            if ((sublen = this._is.read(buffer, offset, sublen)) >= 0) {
                this._length -= (long)sublen;
            }
            return sublen;
        }
    }
}

