/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.journal;

import com.caucho.env.actor.AbstractActorProcessor;
import com.caucho.message.journal.JournalFile;
import com.caucho.message.journal.JournalResult;
import com.caucho.message.journal.JournalRingItem;
import java.io.IOException;

public class JournalWriteActor
extends AbstractActorProcessor<JournalRingItem> {
    private final JournalFile _journalFile;
    private String _threadName;

    public JournalWriteActor(JournalFile journalFile) {
        this._journalFile = journalFile;
        this._threadName = this.toString();
    }

    @Override
    public String getThreadName() {
        return this._threadName;
    }

    @Override
    public final void process(JournalRingItem entry) throws IOException {
        if (entry.isData()) {
            this.processData(entry);
        } else {
            this.processCheckpoint(entry);
        }
    }

    private final void processData(JournalRingItem entry) throws IOException {
        byte[] buffer = entry.getBuffer();
        if (buffer == null) {
            return;
        }
        long code = entry.getCode();
        long xid = entry.getXid();
        long qid = entry.getQid();
        long mid = entry.getMid();
        JournalResult result = entry.getResult();
        this._journalFile.write(code, entry.isInit(), entry.isFin(), xid, qid, mid, buffer, entry.getOffset(), entry.getLength(), result);
        entry.freeTempBuffer();
    }

    private final void processCheckpoint(JournalRingItem entry) throws IOException {
        long blockAddr = entry.getBlockAddr();
        int offset = entry.getOffset();
        int length = entry.getLength();
        this._journalFile.checkpoint(blockAddr, offset, length);
    }

    @Override
    public void onProcessComplete() throws Exception {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._journalFile + "]";
    }
}

