/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.local;

import com.caucho.amqp.AmqpException;
import com.caucho.message.MessageEncoder;
import com.caucho.message.MessagePropertiesFactory;
import com.caucho.message.broker.BrokerSender;
import com.caucho.message.broker.EnvironmentMessageBroker;
import com.caucho.message.common.AbstractMessageSender;
import com.caucho.message.local.LocalSenderFactory;
import com.caucho.util.L10N;
import com.caucho.vfs.TempOutputStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Map;

public class LocalSender<T>
extends AbstractMessageSender<T> {
    private static final L10N L = new L10N(LocalSender.class);
    private String _address;
    private MessageEncoder<T> _encoder;
    private BrokerSender _publisher;
    private long _lastMessageId;
    private WriteStream _os;

    LocalSender(LocalSenderFactory factory) {
        super(factory);
        this._address = factory.getAddress();
        this._encoder = factory.getMessageEncoder();
        EnvironmentMessageBroker broker = EnvironmentMessageBroker.getCurrent();
        Map<String, Object> nodeProperties = null;
        this._publisher = broker.createSender(this._address, nodeProperties);
        if (this._publisher == null) {
            throw new IllegalArgumentException(L.l("'{0}' is an unknown queue", (Object)this._address));
        }
        this._os = new WriteStream();
        this._os.setReuseBuffer(true);
    }

    public String getAddress() {
        return this._address;
    }

    @Override
    protected boolean offerMicros(MessagePropertiesFactory<T> factory, T value, long timeoutMicros) {
        try {
            TempOutputStream tOut = new TempOutputStream();
            this._encoder.encode(tOut, value);
            tOut.flush();
            tOut.close();
            long xid = 0L;
            long mid = this._publisher.nextMessageId();
            boolean isDurable = false;
            int priority = factory.getPriority();
            long expireTime = 0L;
            this._lastMessageId = mid;
            this._publisher.message(xid, mid, isDurable, priority, expireTime, tOut.getHead().getBuffer(), 0, tOut.getLength(), tOut.getHead(), null);
            return true;
        }
        catch (IOException e) {
            throw new AmqpException(e);
        }
    }

    @Override
    public long getLastMessageId() {
        return this._lastMessageId;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public void close() {
        BrokerSender pub = this._publisher;
        this._publisher = null;
        if (pub != null) {
            pub.close();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "]";
    }
}

