/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.program;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.program.ChoiceItem;
import com.caucho.relaxng.program.EmptyItem;
import com.caucho.relaxng.program.Item;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.util.HashSet;
import java.util.Iterator;

public class InterleaveItem
extends Item {
    protected static final L10N L = new L10N(InterleaveItem.class);
    private boolean _allEmpty = true;
    private Item[] _items = new Item[8];
    private int _size;

    public static Item create(Item left, Item right) {
        InterleaveItem item = new InterleaveItem();
        item.addItem(left);
        item.addItem(right);
        return item.getMin();
    }

    public void addItem(Item item) {
        if (item == null) {
            this._allEmpty = false;
            return;
        }
        if (item instanceof EmptyItem) {
            return;
        }
        if (item instanceof InterleaveItem) {
            InterleaveItem interleave = (InterleaveItem)item;
            for (int i = 0; i < interleave._size; ++i) {
                this.addItem(interleave._items[i]);
            }
            return;
        }
        this._allEmpty = false;
        while (this._items.length <= this._size) {
            Item[] newItems = new Item[this._items.length * 2];
            System.arraycopy(this._items, 0, newItems, 0, this._items.length);
            this._items = newItems;
        }
        this._items[this._size++] = item;
    }

    public Item getMin() {
        if (this._size == 0) {
            return this._allEmpty ? EmptyItem.create() : null;
        }
        if (this._size == 1) {
            return this._items[0];
        }
        return this;
    }

    @Override
    public void firstSet(HashSet<QName> set) {
        for (int i = 0; i < this._size; ++i) {
            this._items[i].firstSet(set);
        }
    }

    @Override
    public void requiredFirstSet(HashSet<QName> set) {
        if (this.allowEmpty()) {
            return;
        }
        for (int i = 0; i < this._size; ++i) {
            this._items[i].requiredFirstSet(set);
        }
    }

    @Override
    public boolean allowEmpty() {
        for (int i = 0; i < this._size; ++i) {
            if (this._items[i].allowEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Item interleaveContinuation(Item cont) {
        InterleaveItem item = new InterleaveItem();
        for (int i = 0; i < this._size; ++i) {
            item.addItem(this._items[i].interleaveContinuation(cont));
        }
        return item.getMin();
    }

    @Override
    public Item inElementContinuation(Item cont) {
        InterleaveItem item = new InterleaveItem();
        for (int i = 0; i < this._size; ++i) {
            item.addItem(this._items[i].inElementContinuation(cont));
        }
        return item.getMin();
    }

    @Override
    public Item groupContinuation(Item cont) {
        InterleaveItem item = new InterleaveItem();
        for (int i = 0; i < this._size; ++i) {
            item.addItem(this._items[i].groupContinuation(cont));
        }
        return item.getMin();
    }

    @Override
    public Iterator<Item> getItemsIterator() {
        if (this._size == 0) {
            return this.emptyItemIterator();
        }
        return new ArrayIterator(this._items, this._size);
    }

    @Override
    public Item startElement(QName name) throws RelaxException {
        InterleaveItem result = null;
        ChoiceItem choice = null;
        int size = this._size;
        Item[] items = this._items;
        for (int i = 0; i < size; ++i) {
            Item resultItem;
            Item item = items[i];
            Item nextItem = item.startElement(name);
            if (nextItem == null) continue;
            if (nextItem == item) {
                resultItem = this;
            } else {
                InterleaveItem rest = new InterleaveItem();
                for (int j = 0; j < size; ++j) {
                    if (i == j) continue;
                    rest.addItem(items[j]);
                }
                resultItem = nextItem.interleaveContinuation(rest);
            }
            if (result == null) {
                result = resultItem;
                continue;
            }
            if (choice == null) {
                choice = new ChoiceItem();
                choice.addItem(result);
            }
            choice.addItem(resultItem);
        }
        if (choice != null) {
            return choice.getMin();
        }
        return result;
    }

    @Override
    public boolean allowAttribute(QName name, String value) throws RelaxException {
        for (int i = this._size - 1; i >= 0; --i) {
            if (!this._items[i].allowAttribute(name, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void attributeSet(HashSet<QName> set) {
        for (int i = 0; i < this._size; ++i) {
            this._items[i].attributeSet(set);
        }
    }

    @Override
    public Item setAttribute(QName name, String value) throws RelaxException {
        if (!this.allowAttribute(name, value)) {
            return this;
        }
        InterleaveItem interleave = new InterleaveItem();
        for (int i = this._size - 1; i >= 0; --i) {
            Item next = this._items[i].setAttribute(name, value);
            if (next == null) continue;
            interleave.addItem(next);
        }
        return interleave.getMin();
    }

    @Override
    public Item attributeEnd() {
        InterleaveItem interleave = new InterleaveItem();
        for (int i = this._size - 1; i >= 0; --i) {
            Item next = this._items[i].attributeEnd();
            if (next == null) {
                return null;
            }
            interleave.addItem(next);
        }
        if (interleave.equals(this)) {
            return this;
        }
        return interleave.getMin();
    }

    @Override
    public Item text(CharSequence string) throws RelaxException {
        InterleaveItem result = null;
        ChoiceItem choice = null;
        Item[] items = this._items;
        for (int i = 0; i < this._size; ++i) {
            Item resultItem;
            Item item = items[i];
            Item nextItem = item.text(string);
            if (nextItem == null) continue;
            if (nextItem == item) {
                resultItem = this;
            } else {
                InterleaveItem rest = new InterleaveItem();
                for (int j = 0; j < this._size; ++j) {
                    if (i == j) continue;
                    rest.addItem(items[j]);
                }
                resultItem = nextItem.interleaveContinuation(rest);
            }
            if (result == null) {
                result = resultItem;
                continue;
            }
            if (choice == null) {
                choice = new ChoiceItem();
                choice.addItem(result);
            }
            choice.addItem(resultItem);
        }
        if (choice != null) {
            return choice.getMin();
        }
        return result;
    }

    @Override
    public boolean allowsElement(QName name) {
        for (int i = 0; i < this._size; ++i) {
            Item subItem = this._items[i];
            if (!subItem.allowsElement(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toSyntaxDescription(int depth) {
        if (this._size == 1) {
            return this._items[0].toSyntaxDescription(depth);
        }
        CharBuffer cb = CharBuffer.allocate();
        cb.append("(");
        boolean isSimple = true;
        for (int i = 0; i < this._size; ++i) {
            Item item = this._items[i];
            if (!item.isSimpleSyntax()) {
                isSimple = false;
            }
            if (i == 0) {
                if (!isSimple) {
                    cb.append(" ");
                }
            } else if (isSimple) {
                cb.append(" & ");
            } else {
                this.addSyntaxNewline(cb, depth);
                cb.append("& ");
            }
            cb.append(item.toSyntaxDescription(depth + 2));
        }
        cb.append(')');
        return cb.close();
    }

    public int hashCode() {
        int hash = 37;
        for (int i = 0; i < this._size; ++i) {
            hash += this._items[i].hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InterleaveItem)) {
            return false;
        }
        InterleaveItem interleave = (InterleaveItem)o;
        if (this._size != interleave._size) {
            return false;
        }
        return this.isSubset(interleave);
    }

    private boolean isSubset(InterleaveItem item) {
        int size = this._size;
        Item[] items = this._items;
        for (int i = size - 1; i >= 0; --i) {
            Item subItem = items[i];
            if (item._items[i].equals(subItem) || item.contains(subItem)) continue;
            return false;
        }
        return true;
    }

    private boolean contains(Item subItem) {
        Item[] items = this._items;
        for (int i = this._size - 1; i >= 0; --i) {
            Item item = items[i];
            if (!item.equals(subItem)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InterleaveItem[");
        for (int i = 0; i < this._size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this._items[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    static class ArrayIterator
    implements Iterator<Item> {
        private Item[] _items;
        private int _size;
        private int _index;

        ArrayIterator(Item[] items, int size) {
            this._items = items;
            this._size = size;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._size;
        }

        @Override
        public Item next() {
            if (this._index < this._size) {
                return this._items[this._index++];
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

