/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.bam.broker.ManagedBroker;
import com.caucho.config.AdminLiteral;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.RawString;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.security.AdminAuthenticator;
import com.caucho.security.Authenticator;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.PasswordUser;
import com.caucho.security.XmlAuthenticator;
import com.caucho.server.admin.TransactionManager;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.host.HostConfig;
import com.caucho.server.resin.Resin;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.PostConstruct;

@Configurable
public class Management {
    private static L10N L = new L10N(Management.class);
    public static final String HOST_NAME = "admin.caucho";
    private Resin _resin;
    private ServletService _server;
    private HostConfig _hostConfig;
    private AdminAuthenticator _auth;
    protected TransactionManager _transactionManager;
    private Lifecycle _lifecycle = new Lifecycle();

    public Management() {
        this(Resin.getCurrent());
    }

    public Management(Resin resin) {
        this._resin = resin;
    }

    public void setResin(Resin resin) {
        this._resin = resin;
    }

    public void setServer(ServletService server) {
        this._server = server;
    }

    public String getServerId() {
        return Resin.getCurrent().getServerId();
    }

    public void setPath(Path path) {
    }

    public XmlAuthenticator.User createUser() {
        if (this._auth == null) {
            this._auth = new AdminAuthenticator();
        }
        return this._auth.createUser();
    }

    public void addUser(XmlAuthenticator.User user) {
        this._auth.addUser(user);
    }

    public ManagedBroker getAdminBroker() {
        if (this._server != null) {
            return this._server.getAdminBroker();
        }
        return null;
    }

    public Object createDeployService() {
        return this.createService("com.caucho.server.admin.DeployService");
    }

    public Object createJmxService() {
        return this.createService("com.caucho.admin.JmxService");
    }

    public Object createLogService() {
        return this.createService("com.caucho.admin.LogService");
    }

    public Object createRemoteService() {
        return this.createService("com.caucho.admin.RemoteAdminService");
    }

    public Object createStatService() {
        return this.createService("com.caucho.admin.StatService");
    }

    public Object createPing() {
        return this.createService("com.caucho.server.admin.HttpPingThread");
    }

    public Object createXaLogService() {
        return this.createService("com.caucho.admin.XaLogService");
    }

    @Deprecated
    public void setManagementPath(Path managementPath) {
        this.setPath(managementPath);
    }

    @Deprecated
    public TransactionManager createTransactionManager() throws ConfigException {
        if (this._transactionManager == null) {
            this._transactionManager = new TransactionManager(this);
        }
        return this._transactionManager;
    }

    @PostConstruct
    public void init() {
        try {
            if (!this._lifecycle.toInit()) {
                return;
            }
            if (this._auth != null) {
                this._auth.init();
                InjectManager cdiManager = InjectManager.create();
                BeanBuilder<Authenticator> factory = cdiManager.createBeanFactory(Authenticator.class);
                factory.type(new Type[]{Authenticator.class});
                factory.type(new Type[]{AdminAuthenticator.class});
                factory.qualifier((Annotation)DefaultLiteral.DEFAULT);
                factory.qualifier(new AdminLiteral());
                cdiManager.addBeanDiscover(factory.singleton(this._auth));
            }
            if (this._transactionManager != null) {
                this._transactionManager.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ConfigException.create(e);
        }
    }

    public void start(ServletService server) {
    }

    public HostConfig getHostConfig() {
        if (this._hostConfig == null) {
            HostConfig hostConfig = new HostConfig();
            hostConfig.setId(HOST_NAME);
            hostConfig.setRootDirectory(new RawString("/bogus-admin"));
            hostConfig.setSkipDefaultConfig(true);
            hostConfig.init();
            try {
                if (this._server == null) {
                    this._server = this._resin.getServer();
                }
                if (this._server != null) {
                    this._server.addHost(hostConfig);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            this._hostConfig = hostConfig;
        }
        return this._hostConfig;
    }

    public double getCpuLoad() {
        return 0.0;
    }

    public void dumpThreads() {
    }

    private Object createService(String className) {
        if (!this._resin.isProfessional()) {
            return new IgnoreConfig();
        }
        int p = className.lastIndexOf(46);
        String shortName = className.substring(p + 1);
        try {
            Class<?> cl = Class.forName(className);
            return cl.newInstance();
        }
        catch (Exception e) {
            throw ConfigException.create(L.l("{0} is an unavailable service because it requires Resin Professional.\n  {1}", (Object)shortName, (Object)e.toString()), (Throwable)e);
        }
    }

    public void destroy() {
        TransactionManager transactionManager = this._transactionManager;
        this._transactionManager = null;
        if (transactionManager != null) {
            transactionManager.destroy();
        }
    }

    static class IgnoreConfig {
        IgnoreConfig() {
        }

        public void addBuilderProgram(ConfigProgram program) {
        }
    }

    public static class User {
        private String _name;
        private String _password;
        private boolean _isDisabled;

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setPassword(String password) {
            this._password = password;
        }

        public String getPassword() {
            return this._password;
        }

        public void setDisable(boolean isDisabled) {
            this._isDisabled = isDisabled;
        }

        public boolean isDisable() {
            return this._isDisabled;
        }

        PasswordUser getPasswordUser() {
            if (this._name == null) {
                throw new ConfigException(L.l("management <user> requires a 'name' attribute"));
            }
            boolean isAnonymous = false;
            return new PasswordUser(new BasicPrincipal(this._name), this._password.toCharArray(), this._isDisabled, isAnonymous, new String[]{"resin-admin"});
        }
    }
}

