/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.env.repository.Repository;
import com.caucho.env.repository.RepositoryTagListener;
import com.caucho.server.host.HostExpandDeployGenerator;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HostWebAppDeployListener
implements RepositoryTagListener {
    private static final Logger log = Logger.getLogger(HostWebAppDeployListener.class.getName());
    private final HostExpandDeployGenerator _gen;
    private final String _idPrefix;

    HostWebAppDeployListener(HostExpandDeployGenerator gen) {
        this._gen = gen;
        this._idPrefix = gen.getContainer().getStageTag() + "/webapp";
        this.getRepository().addListener(this._idPrefix, this);
    }

    Path getExpandDirectory() {
        return this._gen.getExpandDirectory();
    }

    Repository getRepository() {
        return this._gen.getRepository();
    }

    void update() {
        for (String key : this.getRepository().getTagMap().keySet()) {
            if (!key.startsWith(this._idPrefix)) continue;
            String host = key.substring(this._idPrefix.length() + 1);
            int p = host.indexOf(47);
            if (p >= 0) {
                host = host.substring(0, p);
            }
            if (host.length() == 0) continue;
            try {
                this.getExpandDirectory().lookup(host).mkdirs();
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    @Override
    public void onTagChange(String tag) {
        this.update();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getExpandDirectory() + "]";
    }
}

