/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.config.ConfigException;
import com.caucho.server.security.AbstractConstraint;
import com.caucho.server.security.AuthorizationResult;
import com.caucho.util.InetNetwork;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IPConstraint
extends AbstractConstraint {
    private static final Logger log = Logger.getLogger(IPConstraint.class.getName());
    static L10N L = new L10N(IPConstraint.class);
    private ArrayList<InetNetwork> _allowNetworkList;
    private ArrayList<InetNetwork> _denyNetworkList;
    private int _cacheSize = 256;
    private int _errorCode = 403;
    private String _errorMessage = L.l("Forbidden IP Address");
    private LruCache<String, Boolean> _cache;
    private boolean _oldStyle = false;

    public void setErrorCode(int errorCode) {
        this._errorCode = errorCode;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this._errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public void setCacheSize(int cacheSize) {
        this._cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this._cacheSize;
    }

    public void addAllow(String network) throws UnknownHostException {
        if (this._allowNetworkList == null) {
            this._allowNetworkList = new ArrayList();
        }
        this._allowNetworkList.add(InetNetwork.create(network));
    }

    public void addDeny(String network) throws UnknownHostException {
        if (this._denyNetworkList == null) {
            this._denyNetworkList = new ArrayList();
        }
        this._denyNetworkList.add(InetNetwork.create(network));
    }

    public void addText(String network) throws UnknownHostException {
        this._oldStyle = true;
        this.addAllow(network);
    }

    boolean isOldStyle() {
        return this._oldStyle;
    }

    void copyInto(IPConstraint target) {
        int i;
        if (this._allowNetworkList != null) {
            for (i = 0; i < this._allowNetworkList.size(); ++i) {
                target.addAllowInetNetwork(this._allowNetworkList.get(i));
            }
        }
        if (this._denyNetworkList != null) {
            for (i = 0; i < this._denyNetworkList.size(); ++i) {
                target.addDenyInetNetwork(this._denyNetworkList.get(i));
            }
        }
    }

    private void addAllowInetNetwork(InetNetwork a) {
        if (this._allowNetworkList == null) {
            this._allowNetworkList = new ArrayList();
        }
        this._allowNetworkList.add(a);
    }

    private void addDenyInetNetwork(InetNetwork d) {
        if (this._denyNetworkList == null) {
            this._denyNetworkList = new ArrayList();
        }
        this._denyNetworkList.add(d);
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._allowNetworkList == null && this._denyNetworkList == null) {
            throw new ConfigException(L.l("<ip-constraint> either '<allow>' or '<deny>' or both are expected"));
        }
        if (this._allowNetworkList != null) {
            this._allowNetworkList.trimToSize();
        }
        if (this._denyNetworkList != null) {
            this._denyNetworkList.trimToSize();
        }
        int rules = this._allowNetworkList == null ? 0 : this._allowNetworkList.size();
        rules += this._denyNetworkList == null ? 0 : this._denyNetworkList.size();
        this._cache = new LruCache(this._cacheSize);
    }

    @Override
    public AuthorizationResult isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        InetNetwork net;
        String remoteAddr = request.getRemoteAddr();
        boolean allow = false;
        InetAddress addr = null;
        if (remoteAddr != null) {
            Boolean cacheValue;
            if (this._cache != null && (cacheValue = this._cache.get(remoteAddr)) != null) {
                allow = cacheValue;
                if (!allow) {
                    response.sendError(this._errorCode, this._errorMessage);
                }
                return allow ? AuthorizationResult.ALLOW : AuthorizationResult.DENY_SENT_RESPONSE;
            }
            addr = InetAddress.getByName(remoteAddr);
        }
        if (this._allowNetworkList == null) {
            allow = true;
        } else {
            for (int i = 0; i < this._allowNetworkList.size(); ++i) {
                net = this._allowNetworkList.get(i);
                if (!net.isMatch(addr)) continue;
                allow = true;
                break;
            }
        }
        if (allow && this._denyNetworkList != null) {
            for (int i = 0; i < this._denyNetworkList.size(); ++i) {
                net = this._denyNetworkList.get(i);
                if (!net.isMatch(addr)) continue;
                allow = false;
                break;
            }
        }
        if (this._cache != null) {
            this._cache.put(remoteAddr, allow ? Boolean.TRUE : Boolean.FALSE);
        }
        if (!allow) {
            response.sendError(this._errorCode, this._errorMessage);
        }
        return allow ? AuthorizationResult.ALLOW : AuthorizationResult.DENY_SENT_RESPONSE;
    }
}

