/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets.ssi;

import com.caucho.servlets.ssi.ErrorStatement;
import com.caucho.servlets.ssi.ExprParser;
import com.caucho.servlets.ssi.SSIExpr;
import com.caucho.servlets.ssi.Statement;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IncludeStatement
extends Statement {
    private final SSIExpr _virtual;

    private IncludeStatement(SSIExpr virtual) {
        this._virtual = virtual;
    }

    static Statement create(HashMap<String, String> attr, Path path) {
        String virtual = attr.get("virtual");
        if (virtual == null) {
            return new ErrorStatement("['virtual' is a required attribute of #include]");
        }
        return new IncludeStatement(ExprParser.parseConcat(virtual, path));
    }

    @Override
    public void apply(WriteStream out, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        out.flushBuffer();
        String path = this._virtual.evalString(request, response);
        RequestDispatcher disp = request.getRequestDispatcher(path);
        disp.include((ServletRequest)request, (ServletResponse)response);
    }
}

