/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.sql.spy.SpyDataSource;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class SpyPooledConnection
implements PooledConnection {
    protected static final Logger log = Logger.getLogger(SpyPooledConnection.class.getName());
    protected static final L10N L = new L10N(SpyPooledConnection.class);
    protected String _id;
    private SpyDataSource _spyDataSource = new SpyDataSource();
    private PooledConnection _pconn;

    public SpyPooledConnection(PooledConnection conn, String id) {
        this._pconn = conn;
        this._id = id;
    }

    protected long start() {
        return CurrentTime.getExactTime();
    }

    protected void log(long start, String msg) {
        long delta = CurrentTime.getExactTime() - start;
        log.fine("[" + delta + "ms] " + this._id + ":" + msg);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this._pconn.addConnectionEventListener(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this._pconn.removeConnectionEventListener(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this._pconn.addStatementEventListener(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this._pconn.removeStatementEventListener(listener);
    }

    @Override
    public Connection getConnection() throws SQLException {
        long start = this.start();
        try {
            Connection conn = this._pconn.getConnection();
            String connId = null;
            if (log.isLoggable(Level.FINE)) {
                connId = this._spyDataSource.createConnectionId(null);
                this.log(start, "connect() -> " + connId + ":" + conn);
            }
            return conn;
        }
        catch (SQLException e) {
            this.log(start, "exn-connect(" + e + ")");
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this._pconn.close();
            log.fine(this._id + ":pool-close()");
        }
        catch (SQLException e) {
            log.fine(this._id + ":exn-close(" + e + ")");
            throw e;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this._id + ",conn=" + this._pconn + "]";
    }
}

