/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Encoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public abstract class AbstractByteToChar
extends InputStream {
    private Reader _readEncoding;
    private String _readEncodingName;
    private int _specialEncoding;
    private final byte[] _byteBuffer = new byte[256];
    private final char[] _charBuffer = new char[1];
    private int _byteHead;
    private int _byteTail;

    AbstractByteToChar() {
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            this._readEncoding = Encoding.getReadEncoding(this, encoding);
            this._readEncodingName = Encoding.getMimeName(encoding);
        } else {
            this._readEncoding = null;
            this._readEncodingName = null;
        }
    }

    public void clear() {
        this._byteHead = 0;
        this._byteTail = 0;
    }

    public void addByte(int b) throws IOException {
        int ch;
        int nextHead = (this._byteHead + 1) % this._byteBuffer.length;
        while (nextHead == this._byteTail && (ch = this.readChar()) >= 0) {
            this.outputChar(ch);
        }
        this._byteBuffer[this._byteHead] = (byte)b;
        this._byteHead = nextHead;
    }

    public void addChar(char nextCh) throws IOException {
        int ch;
        while ((ch = this.readChar()) >= 0) {
            this.outputChar((char)ch);
        }
        this.outputChar(nextCh);
    }

    public void flush() throws IOException {
        int ch;
        while ((ch = this.readChar()) >= 0) {
            this.outputChar((char)ch);
        }
    }

    private int readChar() throws IOException {
        Reader readEncoding = this._readEncoding;
        if (readEncoding == null) {
            return this.read();
        }
        if (readEncoding.read(this._charBuffer, 0, 1) < 0) {
            return -1;
        }
        return this._charBuffer[0];
    }

    @Override
    public int read() throws IOException {
        if (this._byteHead == this._byteTail) {
            return -1;
        }
        int b = this._byteBuffer[this._byteTail] & 0xFF;
        this._byteTail = (this._byteTail + 1) % this._byteBuffer.length;
        return b;
    }

    protected abstract void outputChar(int var1) throws IOException;
}

