/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;

public class TempInputStream
extends InputStream {
    private TempBuffer _head;
    private int _offset;

    public TempInputStream(TempBuffer head) {
        this._head = head;
    }

    @Override
    public int read() throws IOException {
        TempBuffer head = this._head;
        if (head == null) {
            return -1;
        }
        int value = head._buf[this._offset++] & 0xFF;
        if (head._length <= this._offset) {
            this._head = head._next;
            head._next = null;
            TempBuffer.free(head);
            this._offset = 0;
        }
        return value;
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        TempBuffer head = this._head;
        if (head == null) {
            return -1;
        }
        int sublen = head._length - this._offset;
        if (length < sublen) {
            sublen = length;
        }
        System.arraycopy(head._buf, this._offset, buf, offset, sublen);
        if (head._length <= this._offset + sublen) {
            this._head = head._next;
            head._next = null;
            TempBuffer.free(head);
            this._offset = 0;
        } else {
            this._offset += sublen;
        }
        return sublen;
    }

    @Override
    public int available() throws IOException {
        if (this._head != null) {
            return this._head._length - this._offset;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        TempBuffer head = this._head;
        this._head = null;
        if (head != null) {
            TempBuffer.freeAll(head);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

