/*
 * Copyright (c) 1998-2018 Caucho Technology -- all rights reserved
 *
 * This file is part of Resin(R) Open Source
 *
 * Each copy or derived work must preserve the copyright notice and this
 * notice unmodified.
 *
 * Resin Open Source is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Resin Open Source is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, or any warranty
 * of NON-INFRINGEMENT.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Resin Open Source; if not, write to the
 *
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330
 *   Boston, MA 02111-1307  USA
 *
 * @author Scott Ferguson
 */

package com.caucho.jms.cfg;

import java.util.*;
import java.util.logging.*;

import javax.annotation.*;
import javax.jms.*;

import com.caucho.config.*;
import com.caucho.config.cfg.BeanConfig;
import com.caucho.jms.JmsConnectionFactory;
import com.caucho.jms.message.*;
import com.caucho.jms.connection.*;

import com.caucho.util.*;

/**
 * jms-connection-factory configuration
 */
public class JmsConnectionFactoryConfig extends BeanConfig
{
  private static final L10N L = new L10N(JmsConnectionFactoryConfig.class);
  private static final Logger log
    = Logger.getLogger(JmsConnectionFactoryConfig.class.getName());
  
  public JmsConnectionFactoryConfig()
  {
    setScope("singleton");
    setBeanConfigClass(ConnectionFactory.class);
  }

  public void setClass(Class cl)
  {
    if (! ConnectionFactory.class.isAssignableFrom(cl))
      throw new ConfigException(L.l("'{0}' must implement javax.jms.ConnectionFactory"));

    super.setClass(cl);
  }
  /*
  @PostConstruct
  public void init()
  {
    if (getInstanceClass() == null) {
      JmsConnectionFactory factory = new JmsConnectionFactory();

      register(factory);
    }
    else
      register();
  }
    */
}

