/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractTableConfig;
import com.caucho.amber.cfg.JoinColumnConfig;
import java.util.HashMap;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;

public class JoinTableConfig
extends AbstractTableConfig {
    private HashMap<String, JoinColumnConfig> _joinColumnMap = new HashMap();
    private HashMap<String, JoinColumnConfig> _inverseJoinColumnMap = new HashMap();

    public JoinTableConfig() {
    }

    public JoinTableConfig(JoinTable joinTable) {
        JoinColumnConfig joinColumnConfig;
        this.setName(joinTable.name());
        this.setCatalog(joinTable.catalog());
        this.setSchema(joinTable.schema());
        for (JoinColumn joinColumn : joinTable.joinColumns()) {
            joinColumnConfig = new JoinColumnConfig(joinColumn);
            this.addJoinColumn(joinColumnConfig);
        }
        for (JoinColumn joinColumn : joinTable.inverseJoinColumns()) {
            joinColumnConfig = new JoinColumnConfig(joinColumn);
            this.addInverseJoinColumn(joinColumnConfig);
        }
    }

    public JoinColumnConfig getJoinColumn(String name) {
        return this._joinColumnMap.get(name);
    }

    public void addJoinColumn(JoinColumnConfig joinColumn) {
        this._joinColumnMap.put(joinColumn.getName(), joinColumn);
    }

    public HashMap<String, JoinColumnConfig> getJoinColumnMap() {
        return this._joinColumnMap;
    }

    public JoinColumnConfig getInverseJoinColumn(String name) {
        return this._inverseJoinColumnMap.get(name);
    }

    public void addInverseJoinColumn(JoinColumnConfig joinColumn) {
        this._inverseJoinColumnMap.put(joinColumn.getName(), joinColumn);
    }

    public HashMap<String, JoinColumnConfig> getInverseJoinColumnMap() {
        return this._inverseJoinColumnMap;
    }
}

