/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.entity;

import com.caucho.amber.AmberException;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.entity.CacheableEntityItem;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityFactory;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.entity.XAEntityItem;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.query.CacheUpdate;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmberEntityHome
implements Comparable {
    private static final L10N L = new L10N(AmberEntityHome.class);
    private static final Logger log = Logger.getLogger(AmberEntityHome.class.getName());
    private AmberPersistenceUnit _manager;
    private EntityType _entityType;
    private EntityFactory _entityFactory = new EntityFactory();
    private Entity _homeBean;
    private ArrayList<SoftReference<CacheUpdate>> _cacheUpdates = new ArrayList();
    private volatile boolean _isInit;
    private RuntimeException _configException;
    private Method _cauchoGetBeanMethod;

    public AmberEntityHome(AmberPersistenceUnit manager, EntityType type) {
        this._manager = manager;
        this._entityType = type;
    }

    public Method getCauchoGetBeanMethod() {
        return this._cauchoGetBeanMethod;
    }

    public AmberPersistenceUnit getManager() {
        return this._manager;
    }

    public EntityType getEntityType() {
        return this._entityType;
    }

    public EntityType getRootType() {
        return this._entityType.getRootType();
    }

    public Class getJavaClass() {
        return this._entityType.getInstanceClass();
    }

    public EntityFactory getEntityFactory() {
        return this._entityFactory;
    }

    public void setEntityFactory(EntityFactory factory) {
        this._entityFactory = factory;
    }

    public long getCacheTimeout() {
        return this._entityType.getCacheTimeout();
    }

    public Class getInstanceClass() {
        return this._entityType.getInstanceClass();
    }

    void link() throws ConfigException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ConfigException {
        AmberEntityHome amberEntityHome = this;
        synchronized (amberEntityHome) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
        }
        this._entityType.init();
        try {
            Class instanceClass = this._entityType.getInstanceClass();
            if (!Modifier.isAbstract(instanceClass.getModifiers())) {
                this._homeBean = (Entity)instanceClass.newInstance();
            }
        }
        catch (Exception e) {
            this._entityType.setConfigException(e);
            this._configException = ConfigException.create(e);
            throw this._configException;
        }
        this._entityType.start();
    }

    public Object getKeyFromEntity(Entity entity) throws AmberException {
        return null;
    }

    public Object toObjectKey(long key) {
        return this._entityType.getId().toObjectKey(key);
    }

    public EntityItem findItem(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        EntityItem item = this._homeBean.__caucho_home_find(aConn, this, rs, index);
        return item;
    }

    public Object loadFull(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        if (this._homeBean == null) {
            throw new NullPointerException("HOME:" + this);
        }
        Entity entity = aConn.getSubEntity(this._homeBean.getClass(), rs.getObject(index));
        if (entity != null && entity.__caucho_getEntityState().isManaged()) {
            return entity;
        }
        EntityItem item = this.findItem(aConn, rs, index);
        if (item == null) {
            return null;
        }
        entity = null;
        Entity value = aConn.getEntityLazy(item);
        if (aConn.isActiveTransaction()) {
            if (value instanceof Entity) {
                entity = value;
            } else if (this._cauchoGetBeanMethod != null) {
                try {
                    entity = (Entity)this._cauchoGetBeanMethod.invoke((Object)value, new Object[0]);
                    entity.__caucho_makePersistent(aConn, item);
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            if (entity == null) {
                entity = aConn.getEntity(item);
            }
        } else {
            entity = item.getEntity();
        }
        int keyLength = this._entityType.getId().getKeyCount();
        entity.__caucho_load(aConn, rs, index + keyLength);
        return entity;
    }

    public Object loadLazy(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        EntityItem item = this.findItem(aConn, rs, index);
        if (item == null) {
            return null;
        }
        return aConn.getEntity(item);
    }

    public EntityItem findEntityItem(AmberConnection aConn, Object key) throws AmberException {
        if (this._homeBean == null && this._configException != null) {
            throw this._configException;
        }
        Entity entity = this._homeBean.__caucho_home_find(aConn, this, key);
        if (entity == null) {
            return null;
        }
        if (aConn.isActiveTransaction()) {
            return new XAEntityItem(this, entity);
        }
        return new CacheableEntityItem(this, entity);
    }

    public EntityItem setEntityItem(Object key, EntityItem item) throws AmberException {
        if (key == null) {
            throw new NullPointerException("primaryKey");
        }
        try {
            item.getEntity().__caucho_setConnection(this._manager.getCacheConnection());
            return this._manager.putEntity(this.getRootType(), key, item);
        }
        catch (Exception e) {
            throw AmberException.create(e);
        }
    }

    public EntityItem findDiscriminatorEntityItem(AmberConnection aConn, Object key, String discriminator) throws SQLException {
        EntityItem item = null;
        item = this._manager.getEntity(this.getRootType(), key);
        if (item == null) {
            EntityType subEntity = this._entityType.getSubClass(discriminator);
            Entity cacheEntity = subEntity.createBean();
            cacheEntity.__caucho_setPrimaryKey(key);
            cacheEntity.__caucho_makePersistent((AmberConnection)this._manager.getCacheConnection(), subEntity);
            item = new CacheableEntityItem(this, cacheEntity);
            if (!aConn.isActiveTransaction()) {
                item = this._manager.putEntity(this.getRootType(), key, item);
            }
        }
        return item;
    }

    public Entity newEntity(Object key) {
        return this._homeBean.__caucho_home_new(this, key, null, null);
    }

    public Entity newDiscriminatorEntity(Object key, String discriminator) {
        if (discriminator == null || key == null) {
            throw new AmberRuntimeException(L.l("{0} is not a valid inheritance key.", key));
        }
        EntityType subType = this._entityType.getSubClass(discriminator);
        return subType.getHome().newEntity(key);
    }

    public Entity makePersistent(Entity entity, AmberConnection aConn, boolean isLazy) throws SQLException {
        entity.__caucho_makePersistent(aConn, this._entityType);
        return entity;
    }

    public void save(AmberConnection aConn, Entity entity) throws SQLException {
        entity.__caucho_lazy_create(aConn, this._entityType);
        if (!this._manager.isJPA()) {
            entity.__caucho_create(aConn, this._entityType);
        }
    }

    public void delete(AmberConnection aConn, Object key) throws SQLException {
        this._manager.removeEntity(this.getRootType(), key);
    }

    public void delete(AmberConnection aConn, long primaryKey) throws SQLException {
    }

    public void update(Entity entity) throws SQLException {
    }

    public void addUpdate(CacheUpdate update) {
        this._cacheUpdates.add(new SoftReference<CacheUpdate>(update));
    }

    public int compareTo(Object b) {
        AmberEntityHome home = (AmberEntityHome)b;
        return this._entityType.getClassName().compareTo(home.getEntityType().getClassName());
    }

    public String toString() {
        return "AmberEntityHome[" + this._entityType + "]";
    }
}

