/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.DependentEntityOneToOneExpr;
import com.caucho.amber.expr.ElementCollectionExpr;
import com.caucho.amber.expr.ElementCollectionSchemaExpr;
import com.caucho.amber.expr.EmbeddedExpr;
import com.caucho.amber.expr.EmbeddedSchemaExpr;
import com.caucho.amber.expr.IdExpr;
import com.caucho.amber.expr.ManyToOneExpr;
import com.caucho.amber.expr.ManyToOneSchemaExpr;
import com.caucho.amber.expr.OneToManyExpr;
import com.caucho.amber.expr.OneToManySchemaExpr;
import com.caucho.amber.expr.OneToOneSchemaExpr;
import com.caucho.amber.expr.SchemaExpr;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.type.AmberBeanType;
import com.caucho.amber.type.EntityType;
import com.caucho.util.L10N;

public class FromIdSchemaExpr
extends SchemaExpr {
    private static final L10N L = new L10N(FromIdSchemaExpr.class);
    private IdExpr _id;

    public FromIdSchemaExpr(IdExpr id) {
        this._id = id;
    }

    @Override
    public String getTailName() {
        return this._id.getId();
    }

    @Override
    public SchemaExpr createField(QueryParser parser, String name) throws QueryParseException {
        AmberBeanType type = this._id.getTargetType();
        AmberField field = type.getField(name);
        if (field == null) {
            throw parser.error(L.l("{0}: '{1}' is an unknown field.", (Object)type.getBeanClass().getName(), (Object)name));
        }
        AmberExpr fieldExpr = this._id.createField(parser, name);
        if (fieldExpr instanceof ManyToOneExpr) {
            return new ManyToOneSchemaExpr((ManyToOneExpr)fieldExpr, name);
        }
        if (fieldExpr instanceof OneToManyExpr) {
            return new OneToManySchemaExpr((OneToManyExpr)fieldExpr);
        }
        if (fieldExpr instanceof ElementCollectionExpr) {
            return new ElementCollectionSchemaExpr((ElementCollectionExpr)fieldExpr);
        }
        if (fieldExpr instanceof DependentEntityOneToOneExpr) {
            return new OneToOneSchemaExpr((DependentEntityOneToOneExpr)fieldExpr, name);
        }
        if (fieldExpr instanceof EmbeddedExpr) {
            return new EmbeddedSchemaExpr((EmbeddedExpr)fieldExpr, name);
        }
        throw parser.error(L.l("{0}: '{1}' must be a collection or one-to-one relationship.", (Object)type.getBeanClass().getName(), (Object)name));
    }

    @Override
    public FromItem addFromItem(QueryParser parser, String id) throws QueryParseException {
        EntityType entityType = (EntityType)this._id.getTargetType();
        return parser.addFromItem(entityType.getTable(), id);
    }
}

